/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftRecipeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.StonecutterContainer;
import org.geysermc.geyser.inventory.recipe.GeyserStonecutterData;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;

public class StonecutterInventoryTranslator
extends AbstractBlockInventoryTranslator<StonecutterContainer> {
    public StonecutterInventoryTranslator() {
        super(2, Blocks.STONECUTTER, org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType.STONECUTTER, (InventoryUpdater)UIInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    protected boolean shouldHandleRequestFirst(ItemStackRequestAction action, StonecutterContainer container) {
        return action.getType() == ItemStackRequestActionType.CRAFT_RECIPE;
    }

    @Override
    protected ItemStackResponse translateSpecialRequest(GeyserSession session, StonecutterContainer container, ItemStackRequest request) {
        CraftRecipeAction data = (CraftRecipeAction)request.getActions()[0];
        GeyserStonecutterData craftingData = (GeyserStonecutterData)session.getStonecutterRecipes().get(data.getRecipeNetworkId());
        if (craftingData == null) {
            return StonecutterInventoryTranslator.rejectRequest(request);
        }
        ItemStack javaOutput = craftingData.output();
        int button = craftingData.buttonId();
        if (container.getStonecutterButton() != button) {
            ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(container.getJavaId(), button);
            session.sendDownstreamGamePacket((Packet)packet);
            container.setStonecutterButton(button);
        }
        if (container.getItem(1).getJavaId() != javaOutput.getId()) {
            container.setItem(1, GeyserItemStack.from(javaOutput), session);
        }
        return this.translateRequest(session, container, request);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        return switch (slotInfoData.getContainerName().getContainer()) {
            case ContainerSlotType.STONECUTTER_INPUT -> 0;
            case ContainerSlotType.STONECUTTER_RESULT, ContainerSlotType.CREATED_OUTPUT -> 1;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot, StonecutterContainer container) {
        if (slot == 0) {
            return new BedrockContainerSlot(ContainerSlotType.STONECUTTER_INPUT, 3);
        }
        if (slot == 1) {
            return new BedrockContainerSlot(ContainerSlotType.STONECUTTER_RESULT, 50);
        }
        return super.javaSlotToBedrockContainer(slot, container);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        if (slot == 0) {
            return 3;
        }
        if (slot == 1) {
            return 50;
        }
        return super.javaSlotToBedrock(slot);
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 1) {
            return SlotType.OUTPUT;
        }
        return super.getSlotType(javaSlot);
    }

    @Override
    public StonecutterContainer createInventory(GeyserSession session, String name, int windowId, ContainerType containerType) {
        return new StonecutterContainer(session, name, windowId, this.size, containerType);
    }

    @Override
    public @Nullable org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType closeContainerType(StonecutterContainer container) {
        return org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType.STONECUTTER;
    }
}

