/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.crypto;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.crypto.Topping;

public final class AesCipher
implements FloodgateCipher {
    public static final int IV_LENGTH = 12;
    private static final int TAG_BIT_LENGTH = 128;
    private static final String CIPHER_NAME = "AES/GCM/NoPadding";
    private final SecureRandom secureRandom = new SecureRandom();
    private final Topping topping;
    private SecretKey secretKey;

    @Override
    public void init(Key key) {
        if (!"AES".equals(key.getAlgorithm())) {
            throw new RuntimeException("Algorithm was expected to be AES, but got " + key.getAlgorithm());
        }
        this.secretKey = (SecretKey)key;
    }

    @Override
    public byte[] encrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_NAME);
        byte[] iv = new byte[12];
        this.secureRandom.nextBytes(iv);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)this.secretKey, spec);
        byte[] cipherText = cipher.doFinal(data);
        if (this.topping != null) {
            iv = this.topping.encode(iv);
            cipherText = this.topping.encode(cipherText);
        }
        return ByteBuffer.allocate(HEADER.length + iv.length + cipherText.length + 1).put(HEADER).put(iv).put((byte)33).put(cipherText).array();
    }

    @Override
    public byte[] decrypt(byte[] cipherTextWithIv) throws Exception {
        this.checkHeader(cipherTextWithIv);
        Cipher cipher = Cipher.getInstance(CIPHER_NAME);
        int bufferLength = cipherTextWithIv.length - HEADER.length;
        ByteBuffer buffer = ByteBuffer.wrap(cipherTextWithIv, HEADER.length, bufferLength);
        int ivLength = 12;
        if (this.topping != null) {
            int mark = buffer.position();
            boolean found = false;
            while (buffer.hasRemaining() && !found) {
                if (buffer.get() != 33) continue;
                found = true;
            }
            ivLength = buffer.position() - mark - 1;
            ((Buffer)buffer).position(mark);
        }
        byte[] iv = new byte[ivLength];
        buffer.get(iv);
        ((Buffer)buffer).position(buffer.position() + 1);
        byte[] cipherText = new byte[buffer.remaining()];
        buffer.get(cipherText);
        if (this.topping != null) {
            iv = this.topping.decode(iv);
            cipherText = this.topping.decode(cipherText);
        }
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)this.secretKey, spec);
        return cipher.doFinal(cipherText);
    }

    public AesCipher(Topping topping) {
        this.topping = topping;
    }
}

