/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.properties.type;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.api.entity.property.type.GeyserFloatEntityProperty;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.FloatEntityProperty;

public final class FloatProperty
extends Record
implements PropertyType<Float, FloatEntityProperty>,
GeyserFloatEntityProperty {
    private final Identifier identifier;
    private final float max;
    private final float min;
    private final @Nullable Float defaultValue;

    public FloatProperty(Identifier identifier, float max, float min, @Nullable Float defaultValue) {
        if (min > max) {
            throw new IllegalArgumentException("Cannot create float entity property (%s) with a minimum value (%s) greater than maximum (%s)!".formatted(identifier, Float.valueOf(min), Float.valueOf(max)));
        }
        if (defaultValue != null && (defaultValue.floatValue() < min || defaultValue.floatValue() > max)) {
            throw new IllegalArgumentException("Cannot create float entity property (%s) with a default value (%s) outside of the range (%s - %s)!".formatted(identifier, defaultValue, Float.valueOf(min), Float.valueOf(max)));
        }
        this.identifier = identifier;
        this.max = max;
        this.min = min;
        this.defaultValue = defaultValue;
    }

    @Override
    public NbtMap nbtMap() {
        return NbtMap.builder().putString("name", this.identifier.toString()).putFloat("max", this.max).putFloat("min", this.min).putInt("type", 1).build();
    }

    @Override
    public FloatEntityProperty defaultValue(int index) {
        return this.createValue(index, Float.valueOf(this.defaultValue == null ? this.min : this.defaultValue.floatValue()));
    }

    @Override
    public FloatEntityProperty createValue(int index, Float value) {
        if (value == null) {
            return this.defaultValue(index);
        }
        return new FloatEntityProperty(index, value.floatValue());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{FloatProperty.class, "identifier;max;min;defaultValue", "identifier", "max", "min", "defaultValue"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatProperty.class, "identifier;max;min;defaultValue", "identifier", "max", "min", "defaultValue"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatProperty.class, "identifier;max;min;defaultValue", "identifier", "max", "min", "defaultValue"}, this, o);
    }

    @Override
    public Identifier identifier() {
        return this.identifier;
    }

    @Override
    public float max() {
        return this.max;
    }

    @Override
    public float min() {
        return this.min;
    }

    @Override
    public @Nullable Float defaultValue() {
        return this.defaultValue;
    }
}

