/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.nbt.NbtUtils;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBlockState;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.FlowerPotBlock;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.populator.CustomBlockRegistryPopulator;
import org.geysermc.geyser.registry.populator.conversion.Conversion827_819;
import org.geysermc.geyser.registry.populator.conversion.Conversion844_827;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v818.Bedrock_v818;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v819.Bedrock_v819;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v827.Bedrock_v827;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v844.Bedrock_v844;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v859.Bedrock_v859;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.BlockPropertyData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.util.JsonUtils;

public final class BlockRegistryPopulator {
    private static List<NbtMap> BLOCKS_NBT;
    public static int MIN_CUSTOM_RUNTIME_ID;
    public static int JAVA_BLOCKS_SIZE;
    private static final long FNV1_64_OFFSET_BASIS = -3750763034362895579L;
    private static final long FNV1_64_PRIME = 1099511628211L;

    public static void populate(Stage stage) {
        switch (stage) {
            case PRE_INIT: 
            case POST_INIT: {
                BlockRegistryPopulator.nullifyBlocksNbt();
                break;
            }
            case INIT_JAVA: {
                BlockRegistryPopulator.registerJavaBlocks();
                break;
            }
            case INIT_BEDROCK: {
                BlockRegistryPopulator.registerBedrockBlocks();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stage: " + String.valueOf((Object)stage));
            }
        }
    }

    private static void nullifyBlocksNbt() {
        BLOCKS_NBT = null;
    }

    private static void registerBedrockBlocks() {
        ImmutableMap blockMappers = ImmutableMap.builder().put((Object)ObjectIntPair.of((Object)"1_21_90", (int)Bedrock_v818.CODEC.getProtocolVersion()), Conversion827_819::remapBlock).put((Object)ObjectIntPair.of((Object)"1_21_90", (int)Bedrock_v819.CODEC.getProtocolVersion()), Conversion827_819::remapBlock).put((Object)ObjectIntPair.of((Object)"1_21_100", (int)Bedrock_v827.CODEC.getProtocolVersion()), Conversion844_827::remapBlock).put((Object)ObjectIntPair.of((Object)"1_21_110", (int)Bedrock_v844.CODEC.getProtocolVersion()), tag -> tag).put((Object)ObjectIntPair.of((Object)"1_21_110", (int)Bedrock_v859.CODEC.getProtocolVersion()), tag -> tag).put((Object)ObjectIntPair.of((Object)"1_21_110", (int)860), tag -> tag).build();
        Interner statesInterner = Interners.newStrongInterner();
        for (ObjectIntPair palette : blockMappers.keySet()) {
            ArrayList<NbtMap> blockStates;
            ArrayList<NbtMap> vanillaBlockStates;
            int protocolVersion = palette.valueInt();
            try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(String.format("bedrock/block_palette.%s.nbt", palette.key()));
                 NBTInputStream nbtInputStream = new NBTInputStream((DataInput)new DataInputStream(new GZIPInputStream(stream)), true, true);){
                NbtMap blockPalette = (NbtMap)nbtInputStream.readTag();
                vanillaBlockStates = new ArrayList<NbtMap>(blockPalette.getList("blocks", NbtType.COMPOUND));
                for (int i = 0; i < vanillaBlockStates.size(); ++i) {
                    CustomBlockData[] builder = ((NbtMap)vanillaBlockStates.get(i)).toBuilder();
                    builder.remove((Object)"version");
                    builder.remove((Object)"name_hash");
                    builder.remove((Object)"network_id");
                    builder.remove((Object)"block_id");
                    builder.putCompound("states", (NbtMap)statesInterner.intern((Object)((NbtMap)builder.remove((Object)"states"))));
                    vanillaBlockStates.set(i, builder.build());
                }
                blockStates = new ArrayList<NbtMap>(vanillaBlockStates);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to get blocks from runtime block states", e);
            }
            ArrayList<BlockPropertyData> customBlockProperties = new ArrayList<BlockPropertyData>();
            ArrayList<NbtMap> customBlockStates = new ArrayList<NbtMap>();
            ArrayList<CustomBlockState> customExtBlockStates = new ArrayList<CustomBlockState>();
            int[] remappedVanillaIds = new int[]{};
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                CustomBlockRegistryPopulator.BLOCK_ID.set(10000);
                for (CustomBlockData customBlock : (CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()) {
                    customBlockProperties.add(CustomBlockRegistryPopulator.generateBlockPropertyData(customBlock, protocolVersion));
                    CustomBlockRegistryPopulator.generateCustomBlockStates(customBlock, customBlockStates, customExtBlockStates);
                }
                blockStates.addAll(customBlockStates);
                GeyserImpl.getInstance().getLogger().debug("Added " + customBlockStates.size() + " custom block states to v" + protocolVersion + " palette.");
                blockStates.sort((a, b) -> Long.compareUnsigned(BlockRegistryPopulator.fnv164(a.getString("name")), BlockRegistryPopulator.fnv164(b.getString("name"))));
            }
            Object2ObjectOpenHashMap blockStateOrderedMap = new Object2ObjectOpenHashMap(blockStates.size());
            GeyserBedrockBlock[] bedrockRuntimeMap = new GeyserBedrockBlock[blockStates.size()];
            for (int i = 0; i < blockStates.size(); ++i) {
                GeyserBedrockBlock block2;
                NbtMap tag2 = (NbtMap)blockStates.get(i);
                if (blockStateOrderedMap.put((Object)tag2, (Object)(block2 = new GeyserBedrockBlock(i, tag2))) != null) {
                    throw new AssertionError((Object)("Duplicate block states in Bedrock palette: " + String.valueOf(tag2)));
                }
                bedrockRuntimeMap[i] = block2;
            }
            Object2ObjectMap customBlockStateDefinitions = Object2ObjectMaps.emptyMap();
            Int2ObjectOpenHashMap extendedCollisionBoxes = new Int2ObjectOpenHashMap();
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                int i;
                customBlockStateDefinitions = new Object2ObjectOpenHashMap(customExtBlockStates.size());
                for (i = 0; i < customExtBlockStates.size(); ++i) {
                    NbtMap tag3 = (NbtMap)customBlockStates.get(i);
                    CustomBlockState blockState = (CustomBlockState)customExtBlockStates.get(i);
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockStateOrderedMap.get((Object)tag3);
                    customBlockStateDefinitions.put((Object)blockState, (Object)bedrockBlock);
                    Set extendedCollisionjavaIds = BlockRegistries.EXTENDED_COLLISION_BOXES.getOrDefault(blockState.block(), null);
                    if (extendedCollisionjavaIds == null) continue;
                    Iterator iterator = extendedCollisionjavaIds.iterator();
                    while (iterator.hasNext()) {
                        int javaId = (Integer)iterator.next();
                        extendedCollisionBoxes.put(javaId, (Object)bedrockBlock);
                    }
                }
                remappedVanillaIds = new int[vanillaBlockStates.size()];
                for (i = 0; i < vanillaBlockStates.size(); ++i) {
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockStateOrderedMap.get(vanillaBlockStates.get(i));
                    remappedVanillaIds[i] = bedrockBlock != null ? bedrockBlock.getRuntimeId() : -1;
                }
            }
            int javaRuntimeId = -1;
            List javaBlockStates = (List)BlockRegistries.BLOCK_STATES.get();
            GeyserBedrockBlock airDefinition = null;
            GeyserBedrockBlock commandBlockDefinition = null;
            GeyserBedrockBlock mobSpawnerBlockDefinition = null;
            GeyserBedrockBlock netherPortalBlockDefinition = null;
            GeyserBedrockBlock waterDefinition = null;
            GeyserBedrockBlock movingBlockDefinition = null;
            Iterator<NbtMap> blocksIterator = BLOCKS_NBT.iterator();
            Remapper stateMapper = (Remapper)blockMappers.get((Object)palette);
            Object[] javaToBedrockBlocks = new GeyserBedrockBlock[JAVA_BLOCKS_SIZE];
            Object[] javaToVanillaBedrockBlocks = new GeyserBedrockBlock[JAVA_BLOCKS_SIZE];
            Int2ObjectOpenHashMap javaToBedrockIdentifiers = new Int2ObjectOpenHashMap();
            Block lastBlockSeen = null;
            List javaPottable = ((List)BlockRegistries.JAVA_BLOCKS.get()).parallelStream().flatMap(block -> {
                FlowerPotBlock flowerPot;
                if (block instanceof FlowerPotBlock && (flowerPot = (FlowerPotBlock)block).flower() != Blocks.AIR) {
                    return Stream.of(flowerPot.flower());
                }
                return null;
            }).toList();
            Object2ObjectOpenHashMap flowerPotBlocks = new Object2ObjectOpenHashMap();
            Object2ObjectOpenHashMap itemFrames = new Object2ObjectOpenHashMap();
            IntArrayList collisionIgnoredBlocks = new IntArrayList();
            ObjectOpenHashSet jigsawDefinitions = new ObjectOpenHashSet();
            Object2ObjectOpenHashMap structureBlockDefinitions = new Object2ObjectOpenHashMap();
            BlockMappings.BlockMappingsBuilder builder = BlockMappings.builder();
            while (blocksIterator.hasNext()) {
                boolean waterlogged;
                GeyserBedrockBlock bedrockDefinition;
                NbtMap entry = blocksIterator.next();
                BlockState blockState = (BlockState)javaBlockStates.get(++javaRuntimeId);
                String javaId = blockState.toString();
                NbtMap originalBedrockTag = BlockRegistryPopulator.buildBedrockState(blockState, entry);
                NbtMap bedrockTag = stateMapper.remap(originalBedrockTag);
                GeyserBedrockBlock vanillaBedrockDefinition = (GeyserBedrockBlock)blockStateOrderedMap.get((Object)bedrockTag);
                CustomBlockState blockStateOverride = (CustomBlockState)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get(javaRuntimeId);
                if (blockStateOverride == null) {
                    bedrockDefinition = vanillaBedrockDefinition;
                    if (bedrockDefinition == null) {
                        throw new RuntimeException("Unable to find %s Bedrock runtime ID for %s! Original block tag:\n%s\nUpdated block tag:\n%s".formatted(javaId, palette.key(), originalBedrockTag, bedrockTag));
                    }
                } else {
                    bedrockDefinition = (GeyserBedrockBlock)customBlockStateDefinitions.get((Object)blockStateOverride);
                    if (bedrockDefinition == null) {
                        throw new RuntimeException("Unable to find " + javaId + " Bedrock runtime ID! Custom block override: \n" + String.valueOf(blockStateOverride));
                    }
                }
                switch (javaId) {
                    case "minecraft:air": {
                        airDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:water[level=0]": {
                        waterDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:command_block[conditional=false,facing=north]": {
                        commandBlockDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:spawner": {
                        mobSpawnerBlockDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:moving_piston[facing=north,type=normal]": {
                        movingBlockDefinition = bedrockDefinition;
                    }
                }
                Block block3 = blockState.block();
                if (block3 != lastBlockSeen) {
                    lastBlockSeen = block3;
                    String bedrockName = bedrockDefinition.getState().getString("name");
                    if (!block3.javaIdentifier().toString().equals(bedrockName)) {
                        javaToBedrockIdentifiers.put(block3.javaId(), (Object)bedrockName.substring("minecraft:".length()).intern());
                    }
                }
                if (block3 == Blocks.JIGSAW) {
                    jigsawDefinitions.add(bedrockDefinition);
                }
                if (block3 == Blocks.STRUCTURE_BLOCK) {
                    String mode = blockState.getValue(Properties.STRUCTUREBLOCK_MODE);
                    structureBlockDefinitions.put(mode.toUpperCase(Locale.ROOT), bedrockDefinition);
                }
                if (block3 == Blocks.NETHER_PORTAL) {
                    netherPortalBlockDefinition = bedrockDefinition;
                }
                if (block3 == Blocks.BAMBOO || block3 == Blocks.POINTED_DRIPSTONE) {
                    collisionIgnoredBlocks.add(javaRuntimeId);
                }
                boolean bl = waterlogged = blockState.getValue(Properties.WATERLOGGED, false) != false || block3 == Blocks.BUBBLE_COLUMN || block3 == Blocks.KELP || block3 == Blocks.KELP_PLANT || block3 == Blocks.SEAGRASS || block3 == Blocks.TALL_SEAGRASS;
                if (waterlogged) {
                    ((BitSet)BlockRegistries.WATERLOGGED.get()).set(javaRuntimeId);
                }
                if (javaPottable.contains(block3)) {
                    flowerPotBlocks.put(block3, (NbtMap)blockStates.get(bedrockDefinition.getRuntimeId()));
                }
                javaToVanillaBedrockBlocks[javaRuntimeId] = vanillaBedrockDefinition;
                javaToBedrockBlocks[javaRuntimeId] = bedrockDefinition;
            }
            builder.collisionIgnoredBlocks(collisionIgnoredBlocks);
            if (commandBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find command block in palette");
            }
            builder.commandBlock(commandBlockDefinition);
            if (mobSpawnerBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find mob spawner block in palette");
            }
            builder.mobSpawnerBlock(mobSpawnerBlockDefinition);
            if (netherPortalBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find nether portal block in palette");
            }
            builder.netherPortalBlock(netherPortalBlockDefinition);
            if (waterDefinition == null) {
                throw new AssertionError((Object)"Unable to find water in palette");
            }
            builder.bedrockWater(waterDefinition);
            if (airDefinition == null) {
                throw new AssertionError((Object)"Unable to find air in palette");
            }
            builder.bedrockAir(airDefinition);
            if (movingBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find moving block in palette");
            }
            builder.bedrockMovingBlock(movingBlockDefinition);
            Map nonVanillaStateOverrides = (Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get();
            if (!nonVanillaStateOverrides.isEmpty()) {
                Arrays.fill(javaToVanillaBedrockBlocks, MIN_CUSTOM_RUNTIME_ID, javaToVanillaBedrockBlocks.length, airDefinition);
                Arrays.fill(javaToBedrockBlocks, MIN_CUSTOM_RUNTIME_ID, javaToBedrockBlocks.length, airDefinition);
                for (Map.Entry entry : nonVanillaStateOverrides.entrySet()) {
                    GeyserBedrockBlock bedrockDefinition = (GeyserBedrockBlock)customBlockStateDefinitions.get(entry.getValue());
                    if (bedrockDefinition == null) {
                        GeyserImpl.getInstance().getLogger().warning("Unable to find custom block for " + String.valueOf(entry.getValue()));
                        continue;
                    }
                    JavaBlockState javaState = (JavaBlockState)entry.getKey();
                    int stateRuntimeId = javaState.javaId();
                    boolean waterlogged = javaState.waterlogged();
                    if (waterlogged) {
                        BlockRegistries.WATERLOGGED.register(set -> set.set(stateRuntimeId));
                    }
                    javaToVanillaBedrockBlocks[stateRuntimeId] = bedrockDefinition;
                    javaToBedrockBlocks[stateRuntimeId] = bedrockDefinition;
                    javaToBedrockIdentifiers.put(((JavaBlockState)entry.getKey()).stateGroupId(), (Object)((CustomBlockState)entry.getValue()).block().identifier());
                }
            }
            javaToBedrockIdentifiers.trim();
            Object2ObjectMaps.fastForEach((Object2ObjectMap)blockStateOrderedMap, arg_0 -> BlockRegistryPopulator.lambda$registerBedrockBlocks$6((Map)itemFrames, arg_0));
            BlockRegistries.BLOCKS.register(palette.valueInt(), builder.bedrockRuntimeMap(bedrockRuntimeMap).javaToBedrockBlocks((GeyserBedrockBlock[])javaToBedrockBlocks).javaToVanillaBedrockBlocks((GeyserBedrockBlock[])javaToVanillaBedrockBlocks).javaToBedrockIdentifiers((Int2ObjectMap<String>)javaToBedrockIdentifiers).stateDefinitionMap((Map<NbtMap, GeyserBedrockBlock>)blockStateOrderedMap).itemFrames((Map<NbtMap, BlockDefinition>)itemFrames).flowerPotBlocks((Map<Block, NbtMap>)flowerPotBlocks).jigsawStates((Set<BlockDefinition>)jigsawDefinitions).structureBlockStates((Map<String, BlockDefinition>)structureBlockDefinitions).remappedVanillaIds(remappedVanillaIds).blockProperties(customBlockProperties).customBlockStateDefinitions((Object2ObjectMap<CustomBlockState, GeyserBedrockBlock>)customBlockStateDefinitions).extendedCollisionBoxes((Int2ObjectMap<GeyserBedrockBlock>)extendedCollisionBoxes).build());
        }
    }

    private static void registerJavaBlocks() {
        JsonObject blockInteractionsJson;
        List blocksNbt;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/blocks.nbt");){
            blocksNbt = ((NbtMap)NbtUtils.createGZIPReader((InputStream)stream).readTag()).getList("bedrock_mappings", NbtType.COMPOUND);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block mappings", e);
        }
        int javaRuntimeId = -1;
        for (BlockState javaBlockState : (List)BlockRegistries.BLOCK_STATES.get()) {
            String javaId = javaBlockState.toString().intern();
            BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.register(javaId, ++javaRuntimeId);
        }
        BLOCKS_NBT = blocksNbt;
        JAVA_BLOCKS_SIZE = blocksNbt.size();
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/interactions.json");){
            blockInteractionsJson = JsonUtils.fromJson(stream);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block interaction mappings", e);
        }
        BlockRegistries.INTERACTIVE.set(BlockRegistryPopulator.toBlockStateSet(blockInteractionsJson.getAsJsonArray("always_consumes")));
        BlockRegistries.INTERACTIVE_MAY_BUILD.set(BlockRegistryPopulator.toBlockStateSet(blockInteractionsJson.getAsJsonArray("requires_may_build")));
    }

    private static BitSet toBlockStateSet(JsonArray node) {
        BitSet blockStateSet = new BitSet(node.size());
        for (JsonElement javaIdentifier : node) {
            blockStateSet.set(((Object2IntMap)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.get()).getInt((Object)javaIdentifier.getAsString()));
        }
        return blockStateSet;
    }

    private static NbtMap buildBedrockState(BlockState state, NbtMap nbt) {
        NbtMapBuilder tagBuilder = NbtMap.builder();
        String bedrockIdentifier = "minecraft:" + nbt.getString("bedrock_identifier", state.block().javaIdentifier().value());
        tagBuilder.putString("name", bedrockIdentifier);
        tagBuilder.put("states", (Object)nbt.getCompound("state"));
        return tagBuilder.build();
    }

    private static long fnv164(String str) {
        long hash = -3750763034362895579L;
        for (byte b : str.getBytes(StandardCharsets.UTF_8)) {
            hash *= 1099511628211L;
            hash ^= (long)b;
        }
        return hash;
    }

    private static /* synthetic */ void lambda$registerBedrockBlocks$6(Map itemFrames, Object2ObjectMap.Entry entry) {
        String name = ((NbtMap)entry.getKey()).getString("name");
        if (name.equals("minecraft:frame") || name.equals("minecraft:glow_frame")) {
            itemFrames.put((NbtMap)entry.getKey(), (BlockDefinition)entry.getValue());
        }
    }

    static {
        MIN_CUSTOM_RUNTIME_ID = -1;
        JAVA_BLOCKS_SIZE = -1;
    }

    public static enum Stage {
        PRE_INIT,
        INIT_JAVA,
        INIT_BEDROCK,
        POST_INIT;

    }

    @FunctionalInterface
    static interface Remapper {
        public NbtMap remap(NbtMap var1);
    }
}

