/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipFile;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;

public final class AssetUtils {
    private static final String CLIENT_JAR_HASH_FILE = "client_jar.hash";
    private static final Map<String, Asset> ASSET_MAP = new HashMap<String, Asset>();
    private static VersionDownload CLIENT_JAR_INFO;
    private static final Queue<ClientJarTask> CLIENT_JAR_TASKS;
    private static boolean FORCE_DOWNLOAD_JAR;

    public static Asset getAsset(String name) {
        return ASSET_MAP.get(name);
    }

    public static boolean isAssetKnown(String name) {
        return ASSET_MAP.containsKey(name);
    }

    public static void addTask(boolean required, ClientJarTask task) {
        CLIENT_JAR_TASKS.add(task);
        FORCE_DOWNLOAD_JAR |= required;
    }

    public static CompletableFuture<Void> generateAssetCache() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                VersionManifest versionManifest = (VersionManifest)GeyserImpl.GSON.fromJson(WebUtils.getBody("https://launchermeta.mojang.com/mc/game/version_manifest.json"), VersionManifest.class);
                String latestInfoURL = "";
                for (Version version : versionManifest.getVersions()) {
                    if (!version.getId().equals(GameProtocol.getJavaMinecraftVersion())) continue;
                    latestInfoURL = version.getUrl();
                    break;
                }
                if (latestInfoURL.isEmpty()) {
                    throw new Exception(GeyserLocale.getLocaleStringLog("geyser.locale.fail.latest_version"));
                }
                VersionInfo versionInfo = (VersionInfo)GeyserImpl.GSON.fromJson(WebUtils.getBody(latestInfoURL), VersionInfo.class);
                GeyserImpl.getInstance().getLogger().debug(versionInfo.getDownloads());
                CLIENT_JAR_INFO = versionInfo.getDownloads().get("client");
                GeyserImpl.getInstance().getLogger().debug(CLIENT_JAR_INFO);
                JsonObject assets = ((JsonObject)new JsonParser().parse(WebUtils.getBody(versionInfo.getAssetIndex().getUrl()))).getAsJsonObject("objects");
                for (Map.Entry entry : assets.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("minecraft/lang/")) continue;
                    Asset asset = (Asset)GeyserImpl.GSON.fromJson((JsonElement)entry.getValue(), Asset.class);
                    ASSET_MAP.put((String)entry.getKey(), asset);
                }
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.locale.fail.asset_cache", new Object[]{!e.getMessage().isEmpty() ? e.getMessage() : e.getStackTrace()}));
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadAndRunClientJarTasks() {
        ClientJarTask task;
        if (CLIENT_JAR_INFO == null) {
            GeyserImpl.getInstance().getLogger().debug("Skipping en_US hash check as client jar is null.");
            return;
        }
        if (!FORCE_DOWNLOAD_JAR) {
            String curHash;
            block24: {
                curHash = null;
                try {
                    File hashFile = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve(CLIENT_JAR_HASH_FILE).toFile();
                    if (!hashFile.exists()) break block24;
                    try (BufferedReader br = new BufferedReader(new FileReader(hashFile));){
                        curHash = br.readLine().trim();
                    }
                }
                catch (IOException hashFile) {
                    // empty catch block
                }
            }
            String targetHash = CLIENT_JAR_INFO.getSha1();
            if (targetHash.equals(curHash)) {
                while ((task = CLIENT_JAR_TASKS.poll()) != null) {
                    task.whenDone.run();
                }
                return;
            }
        }
        try {
            GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.locale.download.en_us"));
            GeyserImpl.getInstance().getLogger().debug("Download URL: " + CLIENT_JAR_INFO.getUrl());
            Path tmpFilePath = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("tmp_locale.jar");
            WebUtils.downloadFile(CLIENT_JAR_INFO.getUrl(), tmpFilePath.toString());
            try (ZipFile localeJar = new ZipFile(tmpFilePath.toString());){
                while ((task = CLIENT_JAR_TASKS.poll()) != null) {
                    InputStream fileStream = localeJar.getInputStream(localeJar.getEntry(task.asset));
                    try {
                        task.ifNewDownload.accept(fileStream);
                        task.whenDone.run();
                    }
                    finally {
                        if (fileStream == null) continue;
                        fileStream.close();
                    }
                }
            }
            Path cache = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache");
            Files.createDirectories(cache, new FileAttribute[0]);
            FileUtils.writeFile(cache.resolve(CLIENT_JAR_HASH_FILE).toString(), CLIENT_JAR_INFO.getSha1().toCharArray());
            Files.delete(tmpFilePath);
            GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.locale.download.en_us.done"));
            return;
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.locale.fail.en_us"), e);
        }
    }

    public static void saveFile(Path location, InputStream fileStream) throws IOException {
        try (OutputStream outStream = Files.newOutputStream(location, new OpenOption[0]);){
            int length;
            byte[] buf = new byte[fileStream.available()];
            while ((length = fileStream.read(buf)) != -1) {
                outStream.write(buf, 0, length);
            }
            outStream.flush();
        }
    }

    private AssetUtils() {
    }

    static {
        CLIENT_JAR_TASKS = new ArrayDeque<ClientJarTask>();
        FORCE_DOWNLOAD_JAR = false;
    }

    public static class Asset {
        @SerializedName(value="hash")
        private String hash;
        @SerializedName(value="size")
        private int size;

        public String getHash() {
            return this.hash;
        }

        public int getSize() {
            return this.size;
        }
    }

    static class VersionDownload {
        @SerializedName(value="sha1")
        private String sha1;
        @SerializedName(value="size")
        private int size;
        @SerializedName(value="url")
        private String url;

        VersionDownload() {
        }

        public String toString() {
            return "VersionDownload{sha1='" + this.sha1 + "', size=" + this.size + ", url='" + this.url + "'}";
        }

        public String getSha1() {
            return this.sha1;
        }

        public int getSize() {
            return this.size;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public record ClientJarTask(String asset, InputStreamConsumer ifNewDownload, Runnable whenDone) {
    }

    @FunctionalInterface
    public static interface InputStreamConsumer {
        public void accept(InputStream var1) throws IOException;
    }

    static class VersionManifest {
        @SerializedName(value="latest")
        private LatestVersion latestVersion;
        @SerializedName(value="versions")
        private List<Version> versions;

        VersionManifest() {
        }

        public LatestVersion getLatestVersion() {
            return this.latestVersion;
        }

        public List<Version> getVersions() {
            return this.versions;
        }
    }

    static class Version {
        @SerializedName(value="id")
        private String id;
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="url")
        private String url;
        @SerializedName(value="time")
        private String time;
        @SerializedName(value="releaseTime")
        private String releaseTime;

        Version() {
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public String getTime() {
            return this.time;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }
    }

    static class VersionInfo {
        @SerializedName(value="id")
        private String id;
        @SerializedName(value="type")
        private String type;
        @SerializedName(value="time")
        private String time;
        @SerializedName(value="releaseTime")
        private String releaseTime;
        @SerializedName(value="assetIndex")
        private AssetIndex assetIndex;
        @SerializedName(value="downloads")
        private Map<String, VersionDownload> downloads;

        VersionInfo() {
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getTime() {
            return this.time;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }

        public AssetIndex getAssetIndex() {
            return this.assetIndex;
        }

        public Map<String, VersionDownload> getDownloads() {
            return this.downloads;
        }
    }

    static class AssetIndex {
        @SerializedName(value="id")
        private String id;
        @SerializedName(value="sha1")
        private String sha1;
        @SerializedName(value="size")
        private int size;
        @SerializedName(value="totalSize")
        private int totalSize;
        @SerializedName(value="url")
        private String url;

        AssetIndex() {
        }

        public String getId() {
            return this.id;
        }

        public String getSha1() {
            return this.sha1;
        }

        public int getSize() {
            return this.size;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public String getUrl() {
            return this.url;
        }
    }

    static class LatestVersion {
        @SerializedName(value="release")
        private String release;
        @SerializedName(value="snapshot")
        private String snapshot;

        LatestVersion() {
        }

        public String getRelease() {
            return this.release;
        }

        public String getSnapshot() {
            return this.snapshot;
        }
    }
}

