/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Objects;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.auth.SessionService;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.ClientSession;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.compression.CompressionConfig;
import org.geysermc.mcprotocollib.network.compression.ZlibCompression;
import org.geysermc.mcprotocollib.network.event.session.ConnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.SessionAdapter;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.network.session.ClientNetworkSession;
import org.geysermc.mcprotocollib.protocol.MinecraftConstants;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;
import org.geysermc.mcprotocollib.protocol.data.UnexpectedEncryptionException;
import org.geysermc.mcprotocollib.protocol.data.handshake.HandshakeIntent;
import org.geysermc.mcprotocollib.protocol.data.status.ServerStatusInfo;
import org.geysermc.mcprotocollib.protocol.data.status.handler.ServerInfoHandler;
import org.geysermc.mcprotocollib.protocol.data.status.handler.ServerPingTimeHandler;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundDisconnectPacket;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundKeepAlivePacket;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundTransferPacket;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundKeepAlivePacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundSelectKnownPacks;
import org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound.ServerboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound.ServerboundSelectKnownPacks;
import org.geysermc.mcprotocollib.protocol.packet.handshake.serverbound.ClientIntentionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundStartConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundConfigurationAcknowledgedPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundHelloPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginCompressionPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginDisconnectPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.clientbound.ClientboundLoginFinishedPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundHelloPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundKeyPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundLoginAcknowledgedPacket;
import org.geysermc.mcprotocollib.protocol.packet.ping.clientbound.ClientboundPongResponsePacket;
import org.geysermc.mcprotocollib.protocol.packet.ping.serverbound.ServerboundPingRequestPacket;
import org.geysermc.mcprotocollib.protocol.packet.status.clientbound.ClientboundStatusResponsePacket;
import org.geysermc.mcprotocollib.protocol.packet.status.serverbound.ServerboundStatusRequestPacket;

public class ClientListener
extends SessionAdapter {
    @NonNull
    private final HandshakeIntent handshakeIntent;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void packetReceived(Session session, Packet packet) {
        MinecraftProtocol protocol = session.getPacketProtocol();
        if (protocol.getInboundState() == ProtocolState.LOGIN) {
            if (packet instanceof ClientboundHelloPacket) {
                SecretKey key;
                ClientboundHelloPacket helloPacket = (ClientboundHelloPacket)packet;
                GameProfile profile = session.getFlag(MinecraftConstants.PROFILE_KEY);
                String accessToken = session.getFlag(MinecraftConstants.ACCESS_TOKEN_KEY);
                if ((profile == null || accessToken == null) && helloPacket.isShouldAuthenticate()) {
                    throw new UnexpectedEncryptionException();
                }
                try {
                    KeyGenerator gen = KeyGenerator.getInstance("AES");
                    gen.init(128);
                    key = gen.generateKey();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Failed to generate shared key.", e);
                }
                SessionService sessionService = session.getFlag(MinecraftConstants.SESSION_SERVICE_KEY, new SessionService());
                String serverId = SessionService.getServerId(helloPacket.getServerId(), helloPacket.getPublicKey(), key);
                try {
                    if (helloPacket.isShouldAuthenticate()) {
                        sessionService.joinServer(Objects.requireNonNull(profile, "final shouldAuthenticate changed value?"), accessToken, serverId);
                    }
                }
                catch (IOException e) {
                    session.disconnect((Component)Component.translatable((String)"disconnect.loginFailedInfo", (ComponentLike[])new ComponentLike[]{Component.text((String)e.getMessage())}), (Throwable)e);
                    return;
                }
                session.send(new ServerboundKeyPacket(helloPacket.getPublicKey(), key, helloPacket.getChallenge()), () -> session.setEncryption(protocol.createEncryption(key)));
                return;
            }
            if (packet instanceof ClientboundLoginFinishedPacket) {
                session.switchInboundState(() -> protocol.setInboundState(ProtocolState.CONFIGURATION));
                session.send(new ServerboundLoginAcknowledgedPacket());
                session.switchOutboundState(() -> protocol.setOutboundState(ProtocolState.CONFIGURATION));
                return;
            }
            if (packet instanceof ClientboundLoginDisconnectPacket) {
                ClientboundLoginDisconnectPacket loginDisconnectPacket = (ClientboundLoginDisconnectPacket)packet;
                session.disconnect(loginDisconnectPacket.getReason());
                return;
            }
            if (!(packet instanceof ClientboundLoginCompressionPacket)) return;
            ClientboundLoginCompressionPacket loginCompressionPacket = (ClientboundLoginCompressionPacket)packet;
            int threshold = loginCompressionPacket.getThreshold();
            if (threshold < 0) return;
            session.setCompression(new CompressionConfig(threshold, new ZlibCompression(), false));
            return;
        }
        if (protocol.getInboundState() == ProtocolState.STATUS) {
            if (packet instanceof ClientboundStatusResponsePacket) {
                ClientboundStatusResponsePacket statusResponsePacket = (ClientboundStatusResponsePacket)packet;
                ServerStatusInfo info = statusResponsePacket.parseInfo();
                ServerInfoHandler handler = session.getFlag(MinecraftConstants.SERVER_INFO_HANDLER_KEY);
                if (handler != null) {
                    handler.handle(session, info);
                }
                session.send(new ServerboundPingRequestPacket(System.currentTimeMillis()));
                return;
            }
            if (!(packet instanceof ClientboundPongResponsePacket)) return;
            ClientboundPongResponsePacket pongResponsePacket = (ClientboundPongResponsePacket)packet;
            long time = System.currentTimeMillis() - pongResponsePacket.getPingTime();
            ServerPingTimeHandler handler = session.getFlag(MinecraftConstants.SERVER_PING_TIME_HANDLER_KEY);
            if (handler != null) {
                handler.handle(session, time);
            }
            session.disconnect((Component)Component.translatable((String)"multiplayer.status.finished"));
            return;
        }
        if (protocol.getInboundState() == ProtocolState.GAME) {
            if (packet instanceof ClientboundKeepAlivePacket) {
                ClientboundKeepAlivePacket keepAlivePacket = (ClientboundKeepAlivePacket)packet;
                if (session.getFlag(MinecraftConstants.AUTOMATIC_KEEP_ALIVE_MANAGEMENT, true).booleanValue()) {
                    session.send(new ServerboundKeepAlivePacket(keepAlivePacket.getPingId()));
                    return;
                }
            }
            if (packet instanceof ClientboundDisconnectPacket) {
                ClientboundDisconnectPacket disconnectPacket = (ClientboundDisconnectPacket)packet;
                session.disconnect(disconnectPacket.getReason());
                return;
            }
            if (packet instanceof ClientboundStartConfigurationPacket) {
                session.switchInboundState(() -> protocol.setInboundState(ProtocolState.CONFIGURATION));
                session.send(new ServerboundConfigurationAcknowledgedPacket());
                session.switchOutboundState(() -> protocol.setOutboundState(ProtocolState.CONFIGURATION));
                return;
            }
            if (!(packet instanceof ClientboundTransferPacket)) return;
            ClientboundTransferPacket transferPacket = (ClientboundTransferPacket)packet;
            if (session.getFlag(MinecraftConstants.FOLLOW_TRANSFERS, true) == false) return;
            ClientNetworkSession newSession = new ClientNetworkSession(InetSocketAddress.createUnresolved(transferPacket.getHost(), transferPacket.getPort()), session.getPacketProtocol(), session.getPacketHandlerExecutor(), session.getLocalAddress(), ((ClientSession)session).getProxy());
            newSession.setFlags(session.getFlags());
            newSession.setFlag(BuiltinFlags.CLIENT_TRANSFERRING, true);
            session.disconnect((Component)Component.translatable((String)"disconnect.transfer"));
            newSession.connect(true);
            return;
        }
        if (protocol.getInboundState() != ProtocolState.CONFIGURATION) return;
        if (packet instanceof ClientboundKeepAlivePacket) {
            ClientboundKeepAlivePacket keepAlivePacket = (ClientboundKeepAlivePacket)packet;
            if (session.getFlag(MinecraftConstants.AUTOMATIC_KEEP_ALIVE_MANAGEMENT, true).booleanValue()) {
                session.send(new ServerboundKeepAlivePacket(keepAlivePacket.getPingId()));
                return;
            }
        }
        if (packet instanceof ClientboundFinishConfigurationPacket) {
            session.switchInboundState(() -> protocol.setInboundState(ProtocolState.GAME));
            session.send(ServerboundFinishConfigurationPacket.INSTANCE);
            session.switchOutboundState(() -> protocol.setOutboundState(ProtocolState.GAME));
            return;
        }
        if (packet instanceof ClientboundSelectKnownPacks) {
            if (session.getFlag(MinecraftConstants.SEND_BLANK_KNOWN_PACKS_RESPONSE, true) == false) return;
            session.send(new ServerboundSelectKnownPacks(Collections.emptyList()));
            return;
        }
        if (packet instanceof ClientboundDisconnectPacket) {
            ClientboundDisconnectPacket disconnectPacket = (ClientboundDisconnectPacket)packet;
            session.disconnect(disconnectPacket.getReason());
            return;
        }
        if (!(packet instanceof ClientboundTransferPacket)) return;
        ClientboundTransferPacket transferPacket = (ClientboundTransferPacket)packet;
        if (session.getFlag(MinecraftConstants.FOLLOW_TRANSFERS, true) == false) return;
        ClientNetworkSession newSession = new ClientNetworkSession(InetSocketAddress.createUnresolved(transferPacket.getHost(), transferPacket.getPort()), session.getPacketProtocol(), session.getPacketHandlerExecutor(), session.getLocalAddress(), ((ClientSession)session).getProxy());
        newSession.setFlags(session.getFlags());
        newSession.setFlag(BuiltinFlags.CLIENT_TRANSFERRING, true);
        session.disconnect((Component)Component.translatable((String)"disconnect.transfer"));
        newSession.connect(true);
        return;
    }

    @Override
    public void connected(ConnectedEvent event) {
        Session session = event.getSession();
        MinecraftProtocol protocol = session.getPacketProtocol();
        ClientIntentionPacket intention = new ClientIntentionPacket(protocol.getCodec().getProtocolVersion(), session.getFlagSupplied(MinecraftConstants.CLIENT_HOST, () -> ((InetSocketAddress)session.getRemoteAddress()).getHostString()), session.getFlagSupplied(MinecraftConstants.CLIENT_PORT, () -> ((InetSocketAddress)session.getRemoteAddress()).getPort()), this.handshakeIntent);
        ProtocolState targetState = switch (this.handshakeIntent) {
            default -> throw new IncompatibleClassChangeError();
            case HandshakeIntent.LOGIN, HandshakeIntent.TRANSFER -> ProtocolState.LOGIN;
            case HandshakeIntent.STATUS -> ProtocolState.STATUS;
        };
        session.switchInboundState(() -> protocol.setInboundState(targetState));
        session.send(intention);
        session.switchOutboundState(() -> protocol.setOutboundState(targetState));
        switch (targetState) {
            case LOGIN: {
                GameProfile profile = session.getFlag(MinecraftConstants.PROFILE_KEY);
                session.send(new ServerboundHelloPacket(profile.getName(), profile.getId()));
                break;
            }
            case STATUS: {
                session.send(new ServerboundStatusRequestPacket());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)targetState));
            }
        }
    }

    public ClientListener(@NonNull HandshakeIntent handshakeIntent) {
        if (handshakeIntent == null) {
            throw new NullPointerException("handshakeIntent is marked non-null but is null");
        }
        this.handshakeIntent = handshakeIntent;
    }
}

