/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.chunk;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.BitStorage;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.GlobalPalette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.ListPalette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.MapPalette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.Palette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.PaletteType;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.SingletonPalette;

public class DataPalette {
    private static final double LOG_2 = Math.log(2.0);
    @lombok.NonNull
    private Palette palette;
    private BitStorage storage;
    private final PaletteType paletteType;
    private final int globalPaletteBitsPerEntry;

    private DataPalette(@lombok.NonNull Palette palette, BitStorage storage, PaletteType paletteType, int globalPaletteBitsPerEntry) {
        if (palette == null) {
            throw new NullPointerException("palette is marked non-null but is null");
        }
        this.palette = palette;
        this.storage = storage;
        this.paletteType = paletteType;
        this.globalPaletteBitsPerEntry = globalPaletteBitsPerEntry;
    }

    public DataPalette(DataPalette original) {
        this(original.palette.copy(), original.storage == null ? null : new BitStorage(original.storage), original.paletteType, original.globalPaletteBitsPerEntry);
    }

    public static DataPalette createForBlockState(int initialState, int blockStateRegistrySize) {
        return DataPalette.createEmpty(PaletteType.BLOCK_STATE, initialState, blockStateRegistrySize);
    }

    public static DataPalette createForBiome(int initialBiome, int biomeRegistrySize) {
        return DataPalette.createEmpty(PaletteType.BIOME, initialBiome, biomeRegistrySize);
    }

    public static DataPalette createEmpty(PaletteType paletteType, int initial, int registrySize) {
        return DataPalette.create(new SingletonPalette(initial), null, paletteType, registrySize);
    }

    public static DataPalette create(@lombok.NonNull Palette palette, BitStorage storage, PaletteType paletteType, int registrySize) {
        if (palette == null) {
            throw new NullPointerException("palette is marked non-null but is null");
        }
        return new DataPalette(palette, storage, paletteType, DataPalette.calculateBitsPerEntry(registrySize));
    }

    public int get(int x, int y, int z) {
        if (this.storage != null) {
            int id = this.storage.get(this.index(x, y, z));
            return this.palette.idToState(id);
        }
        return this.palette.idToState(0);
    }

    public int set(int x, int y, int z, int state) {
        int id = this.palette.stateToId(state);
        if (id == -1) {
            this.resize();
            id = this.palette.stateToId(state);
        }
        if (this.storage != null) {
            int index = this.index(x, y, z);
            int curr = this.storage.get(index);
            this.storage.set(index, id);
            return curr;
        }
        return state;
    }

    private int sanitizeBitsPerEntry(int bitsPerEntry) {
        if (bitsPerEntry <= this.paletteType.getMaxBitsPerEntry()) {
            return Math.max(this.paletteType.getMinBitsPerEntry(), bitsPerEntry);
        }
        return this.globalPaletteBitsPerEntry;
    }

    private void resize() {
        Palette oldPalette = this.palette;
        BitStorage oldData = this.storage;
        int bitsPerEntry = this.sanitizeBitsPerEntry(oldPalette instanceof SingletonPalette ? 1 : oldData.getBitsPerEntry() + 1);
        this.palette = DataPalette.createPalette(bitsPerEntry, this.paletteType);
        this.storage = new BitStorage(bitsPerEntry, this.paletteType.getStorageSize());
        if (oldPalette instanceof SingletonPalette) {
            this.palette.stateToId(oldPalette.idToState(0));
        } else {
            for (int i = 0; i < this.paletteType.getStorageSize(); ++i) {
                this.storage.set(i, this.palette.stateToId(oldPalette.idToState(oldData.get(i))));
            }
        }
    }

    private static Palette createPalette(int bitsPerEntry, PaletteType paletteType) {
        if (bitsPerEntry <= paletteType.getMinBitsPerEntry()) {
            return new ListPalette(bitsPerEntry);
        }
        if (bitsPerEntry <= paletteType.getMaxBitsPerEntry()) {
            return new MapPalette(bitsPerEntry);
        }
        return new GlobalPalette();
    }

    private int index(int x, int y, int z) {
        return y << this.paletteType.getMaxBitsPerEntry() | z << this.paletteType.getMinBitsPerEntry() | x;
    }

    private static int calculateBitsPerEntry(int registrySize) {
        return (int)Math.ceil(Math.log(registrySize) / LOG_2);
    }

    @lombok.NonNull
    public Palette getPalette() {
        return this.palette;
    }

    public BitStorage getStorage() {
        return this.storage;
    }

    public PaletteType getPaletteType() {
        return this.paletteType;
    }

    public int getGlobalPaletteBitsPerEntry() {
        return this.globalPaletteBitsPerEntry;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPalette)) {
            return false;
        }
        DataPalette other = (DataPalette)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGlobalPaletteBitsPerEntry() != other.getGlobalPaletteBitsPerEntry()) {
            return false;
        }
        Palette this$palette = this.getPalette();
        Palette other$palette = other.getPalette();
        if (this$palette == null ? other$palette != null : !this$palette.equals(other$palette)) {
            return false;
        }
        BitStorage this$storage = this.getStorage();
        BitStorage other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        PaletteType this$paletteType = this.getPaletteType();
        PaletteType other$paletteType = other.getPaletteType();
        return !(this$paletteType == null ? other$paletteType != null : !((Object)((Object)this$paletteType)).equals((Object)other$paletteType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DataPalette;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGlobalPaletteBitsPerEntry();
        Palette $palette = this.getPalette();
        result = result * 59 + ($palette == null ? 43 : $palette.hashCode());
        BitStorage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        PaletteType $paletteType = this.getPaletteType();
        result = result * 59 + ($paletteType == null ? 43 : ((Object)((Object)$paletteType)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "DataPalette(palette=" + String.valueOf(this.getPalette()) + ", storage=" + String.valueOf(this.getStorage()) + ", paletteType=" + String.valueOf((Object)this.getPaletteType()) + ", globalPaletteBitsPerEntry=" + this.getGlobalPaletteBitsPerEntry() + ")";
    }
}

