/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class TNTEntity
extends Entity
implements Tickable {
    private int currentTick;

    public TNTEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position.add(0.0f, definition.offset(), 0.0f), motion, yaw, pitch, headYaw);
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, boolean isOnGround) {
        super.moveRelative(relX, relY + (double)this.definition.offset(), relZ, yaw, pitch, isOnGround);
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsolute(position.add(Vector3f.from((float)0.0f, (float)this.definition.offset(), (float)0.0f)), yaw, pitch, headYaw, isOnGround, teleported);
    }

    public void setFuseLength(IntEntityMetadata entityMetadata) {
        this.currentTick = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.IGNITED, true);
        this.dirtyMetadata.put(EntityDataTypes.FUSE_TIME, this.currentTick);
    }

    @Override
    public void tick() {
        if (this.currentTick == 0) {
            return;
        }
        if (this.currentTick % 5 == 0) {
            this.dirtyMetadata.put(EntityDataTypes.FUSE_TIME, this.currentTick);
            SetEntityDataPacket packet = new SetEntityDataPacket();
            packet.setRuntimeEntityId(this.geyserId);
            packet.getMetadata().put(EntityDataTypes.FUSE_TIME, (Object)this.currentTick);
            this.session.sendUpstreamPacket(packet);
        }
        --this.currentTick;
    }
}

