/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.MobEquipmentPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.CooldownUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundSetCarriedItemPacket;

@Translator(packet=MobEquipmentPacket.class)
public class BedrockMobEquipmentTranslator
extends PacketTranslator<MobEquipmentPacket> {
    @Override
    public void translate(GeyserSession session, MobEquipmentPacket packet) {
        int newSlot = packet.getHotbarSlot();
        if (!session.isSpawned() || newSlot > 8 || packet.getContainerId() != 0 || session.getPlayerInventory().getHeldItemSlot() == newSlot) {
            return;
        }
        session.getBookEditCache().checkForSend();
        GeyserItemStack oldItem = session.getPlayerInventory().getItemInHand();
        session.getPlayerInventory().setHeldItemSlot(newSlot);
        ServerboundSetCarriedItemPacket setCarriedItemPacket = new ServerboundSetCarriedItemPacket(newSlot);
        session.sendDownstreamGamePacket(setCarriedItemPacket);
        GeyserItemStack newItem = session.getPlayerInventory().getItemInHand();
        if (session.isSneaking() && newItem.asItem() == Items.SHIELD) {
            session.scheduleInEventLoop(() -> session.useItem(Hand.MAIN_HAND), session.getNanosecondsPerTick(), TimeUnit.NANOSECONDS);
        }
        if (oldItem.getJavaId() != newItem.getJavaId()) {
            CooldownUtils.sendCooldown(session);
        }
        if (session.getMouseoverEntity() != null) {
            session.getMouseoverEntity().updateInteractiveTag();
        }
    }
}

