/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.erosion.util.LecternUtils;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.InventoryHolder;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.LecternBlock;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WritableBookContent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WrittenBookContent;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;

public class LecternInventoryTranslator
extends AbstractBlockInventoryTranslator<LecternContainer> {
    private boolean receivedBook = false;

    public LecternInventoryTranslator() {
        super(1, Blocks.LECTERN, ContainerType.LECTERN, (InventoryUpdater)ContainerInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    public boolean prepareInventory(GeyserSession session, LecternContainer container) {
        super.prepareInventory(session, container);
        if (container.isBookInPlayerInventory()) {
            this.updateBook(session, container, container.getItem(0));
            this.receivedBook = true;
        } else {
            this.receivedBook = false;
        }
        return true;
    }

    @Override
    public void openInventory(GeyserSession session, LecternContainer container) {
        if (this.receivedBook && !session.isDroppingLecternBook()) {
            super.openInventory(session, container);
        }
    }

    @Override
    public boolean requiresOpeningDelay(GeyserSession session, LecternContainer container) {
        return false;
    }

    @Override
    public void closeInventory(GeyserSession session, LecternContainer container, boolean force) {
        Vector3i position = container.getHolderPosition();
        NbtMapBuilder baseLecternTag = LecternUtils.getBaseLecternTag(position.getX(), position.getY(), position.getZ(), 0);
        BlockEntityUtils.updateBlockEntity(session, baseLecternTag.build(), position);
        session.setPendingOrCurrentBedrockInventoryId(-1);
        super.closeInventory(session, container, force);
        if (container.isUsingRealBlock()) {
            Runnable closeLecternRunnable = () -> {
                boolean hasBook = session.getGeyser().getWorldManager().blockAt(session, position).getValue(Properties.HAS_BOOK, false);
                NbtMap map = LecternBlock.getBaseLecternTag(position, hasBook);
                BlockEntityUtils.updateBlockEntity(session, map, position);
                session.setClosingInventory(false);
                InventoryUtils.openPendingInventory(session);
            };
            if (force) {
                session.scheduleInEventLoop(closeLecternRunnable, 100L, TimeUnit.MILLISECONDS);
            } else {
                closeLecternRunnable.run();
            }
        } else {
            session.setClosingInventory(false);
            InventoryUtils.openPendingInventory(session);
        }
    }

    @Override
    public void updateProperty(GeyserSession session, LecternContainer container, int key, int value) {
        if (key == 0) {
            container.setCurrentBedrockPage(value / 2);
            container.setBlockEntityTag(container.getBlockEntityTag().toBuilder().putInt("page", container.getCurrentBedrockPage()).build());
            BlockEntityUtils.updateBlockEntity(session, container.getBlockEntityTag(), container.getHolderPosition());
        }
    }

    @Override
    public void updateInventory(GeyserSession session, LecternContainer container) {
        GeyserItemStack itemStack = container.getItem(0);
        if (!itemStack.isEmpty()) {
            boolean isDropping = session.isDroppingLecternBook();
            this.updateBook(session, container, itemStack);
            if (!this.receivedBook && !isDropping) {
                this.receivedBook = true;
                this.openInventory(session, container);
            }
        }
    }

    @Override
    public void updateSlot(GeyserSession session, LecternContainer container, int slot) {
        super.updateSlot(session, container, slot);
        if (slot == 0) {
            this.updateBook(session, container, container.getItem(0));
        }
    }

    @Override
    public @Nullable ContainerType closeContainerType(LecternContainer container) {
        return null;
    }

    private void updateBook(GeyserSession session, LecternContainer container, GeyserItemStack book) {
        if (session.isDroppingLecternBook()) {
            InventoryHolder<? extends Inventory> holder = session.getInventoryHolder();
            if (holder != null && !container.isBookInPlayerInventory()) {
                ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(container.getJavaId(), 3);
                session.sendDownstreamGamePacket(packet);
                session.setDroppingLecternBook(false);
                InventoryUtils.closeInventory(session, container.getJavaId(), false);
            }
        } else if (container.getBlockEntityTag() == null) {
            NbtMap blockEntityTag;
            Vector3i position = container.getHolderPosition();
            if (book.hasNonBaseComponents()) {
                int pages = 0;
                WrittenBookContent writtenBookComponents = book.getComponent(DataComponentTypes.WRITTEN_BOOK_CONTENT);
                if (writtenBookComponents != null) {
                    pages = writtenBookComponents.getPages().size();
                } else {
                    WritableBookContent writableBookComponents = book.getComponent(DataComponentTypes.WRITABLE_BOOK_CONTENT);
                    if (writableBookComponents != null) {
                        pages = writableBookComponents.getPages().size();
                    }
                }
                ItemData itemData = book.getItemData(session);
                NbtMapBuilder lecternTag = LecternBlock.getBaseLecternTag(position, pages);
                lecternTag.putCompound("book", NbtMap.builder().putByte("Count", (byte)itemData.getCount()).putShort("Damage", (short)0).putString("Name", "minecraft:written_book").putCompound("tag", itemData.getTag()).build());
                lecternTag.putInt("page", container.getCurrentBedrockPage());
                blockEntityTag = lecternTag.build();
            } else {
                blockEntityTag = LecternBlock.getBaseLecternTag(position, true);
            }
            container.setBlockEntityTag(blockEntityTag);
            BlockEntityUtils.updateBlockEntity(session, blockEntityTag, position);
        }
    }

    @Override
    public LecternContainer createInventory(GeyserSession session, String name, int windowId, org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType containerType) {
        return new LecternContainer(session, name, windowId, this.size, containerType);
    }
}

