/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.helper;

import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannel;
import io.netty.channel.uring.IoUringSocketChannel;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class TransportHelper {
    public static final TransportType TRANSPORT_TYPE = TransportHelper.determineTransportMethod();
    public static final boolean NEW_NETTY = TransportHelper.isClassAvailable("io.netty.channel.MultiThreadIoEventLoopGroup");

    private static TransportType determineTransportMethod() {
        if (!Boolean.getBoolean("Mcpl.disable-native-transport")) {
            if (TransportHelper.isClassAvailable("io.netty.channel.uring.IoUring") && IoUring.isAvailable() && Boolean.getBoolean("Mcpl.io_uring")) {
                return new TransportType(TransportMethod.IO_URING, IoUringServerSocketChannel.class, (ChannelFactory<? extends ServerSocketChannel>)((ChannelFactory)IoUringServerSocketChannel::new), IoUringSocketChannel.class, (ChannelFactory<? extends SocketChannel>)((ChannelFactory)IoUringSocketChannel::new), IoUringDatagramChannel.class, (ChannelFactory<? extends DatagramChannel>)((ChannelFactory)IoUringDatagramChannel::new), (threads, factory) -> new MultiThreadIoEventLoopGroup(threads.intValue(), factory, IoUringIoHandler.newFactory()), IoUring.isTcpFastOpenServerSideAvailable(), IoUring.isTcpFastOpenClientSideAvailable());
            }
            if (TransportHelper.isClassAvailable("io.netty.channel.epoll.Epoll") && Epoll.isAvailable() && Boolean.parseBoolean(System.getProperty("Mcpl.epoll", "true"))) {
                return new TransportType(TransportMethod.EPOLL, EpollServerSocketChannel.class, (ChannelFactory<? extends ServerSocketChannel>)((ChannelFactory)EpollServerSocketChannel::new), EpollSocketChannel.class, (ChannelFactory<? extends SocketChannel>)((ChannelFactory)EpollSocketChannel::new), EpollDatagramChannel.class, (ChannelFactory<? extends DatagramChannel>)((ChannelFactory)EpollDatagramChannel::new), NEW_NETTY ? (threads, factory) -> new MultiThreadIoEventLoopGroup(threads.intValue(), factory, EpollIoHandler.newFactory()) : EpollEventLoopGroup::new, TransportHelper.getSafely(() -> Epoll.isTcpFastOpenServerSideAvailable()), TransportHelper.getSafely(() -> Epoll.isTcpFastOpenClientSideAvailable()));
            }
            if (TransportHelper.isClassAvailable("io.netty.channel.kqueue.KQueue") && KQueue.isAvailable() && Boolean.parseBoolean(System.getProperty("Mcpl.kqueue", "true"))) {
                return new TransportType(TransportMethod.KQUEUE, KQueueServerSocketChannel.class, (ChannelFactory<? extends ServerSocketChannel>)((ChannelFactory)KQueueServerSocketChannel::new), KQueueSocketChannel.class, (ChannelFactory<? extends SocketChannel>)((ChannelFactory)KQueueSocketChannel::new), KQueueDatagramChannel.class, (ChannelFactory<? extends DatagramChannel>)((ChannelFactory)KQueueDatagramChannel::new), NEW_NETTY ? (threads, factory) -> new MultiThreadIoEventLoopGroup(threads.intValue(), factory, KQueueIoHandler.newFactory()) : KQueueEventLoopGroup::new, TransportHelper.getSafely(() -> KQueue.isTcpFastOpenServerSideAvailable()), TransportHelper.getSafely(() -> KQueue.isTcpFastOpenClientSideAvailable()));
            }
        }
        return new TransportType(TransportMethod.NIO, NioServerSocketChannel.class, (ChannelFactory<? extends ServerSocketChannel>)((ChannelFactory)NioServerSocketChannel::new), NioSocketChannel.class, (ChannelFactory<? extends SocketChannel>)((ChannelFactory)NioSocketChannel::new), NioDatagramChannel.class, (ChannelFactory<? extends DatagramChannel>)((ChannelFactory)NioDatagramChannel::new), NEW_NETTY ? (threads, factory) -> new MultiThreadIoEventLoopGroup(threads.intValue(), factory, NioIoHandler.newFactory()) : NioEventLoopGroup::new, false, false);
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean getSafely(Supplier<Boolean> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public record TransportType(TransportMethod method, Class<? extends ServerSocketChannel> serverSocketChannelClass, ChannelFactory<? extends ServerSocketChannel> serverSocketChannelFactory, Class<? extends SocketChannel> socketChannelClass, ChannelFactory<? extends SocketChannel> socketChannelFactory, Class<? extends DatagramChannel> datagramChannelClass, ChannelFactory<? extends DatagramChannel> datagramChannelFactory, BiFunction<Integer, ThreadFactory, EventLoopGroup> eventLoopGroupFactory, boolean supportsTcpFastOpenServer, boolean supportsTcpFastOpenClient) {
    }

    public static enum TransportMethod {
        NIO,
        EPOLL,
        KQUEUE,
        IO_URING;

    }
}

