/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.MinecartEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class DefaultBlockMinecartEntity
extends MinecartEntity {
    public int customBlock = 0;
    public int customBlockOffset = 0;
    public boolean showCustomBlock = false;

    public DefaultBlockMinecartEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityDataTypes.CUSTOM_DISPLAY, (byte)1);
    }

    @Override
    public void spawnEntity() {
        this.updateDefaultBlockMetadata();
        super.spawnEntity();
    }

    @Override
    public void setCustomBlock(IntEntityMetadata entityMetadata) {
        this.customBlock = entityMetadata.getPrimitiveValue();
        if (this.showCustomBlock) {
            this.dirtyMetadata.put(EntityDataTypes.DISPLAY_BLOCK_STATE, this.session.getBlockMappings().getBedrockBlock(this.customBlock));
        }
    }

    @Override
    public void setCustomBlockOffset(IntEntityMetadata entityMetadata) {
        this.customBlockOffset = entityMetadata.getPrimitiveValue();
        if (this.showCustomBlock) {
            this.dirtyMetadata.put(EntityDataTypes.DISPLAY_OFFSET, this.customBlockOffset);
        }
    }

    @Override
    public void setShowCustomBlock(BooleanEntityMetadata entityMetadata) {
        if (entityMetadata.getPrimitiveValue()) {
            this.showCustomBlock = true;
            this.dirtyMetadata.put(EntityDataTypes.DISPLAY_BLOCK_STATE, this.session.getBlockMappings().getBedrockBlock(this.customBlock));
            this.dirtyMetadata.put(EntityDataTypes.DISPLAY_OFFSET, this.customBlockOffset);
        } else {
            this.showCustomBlock = false;
            this.updateDefaultBlockMetadata();
        }
    }

    public void updateDefaultBlockMetadata() {
    }
}

