/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.kyori.adventure.key.Key;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.living.animal.tameable.WolfEntity;
import org.geysermc.geyser.inventory.item.BannerPattern;
import org.geysermc.geyser.inventory.item.GeyserInstrument;
import org.geysermc.geyser.inventory.recipe.TrimRecipe;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.level.JukeboxSong;
import org.geysermc.geyser.level.PaintingType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.session.cache.registry.SimpleJavaRegistry;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.TrimMaterial;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.TrimPattern;
import org.geysermc.geyser.text.ChatDecoration;
import org.geysermc.geyser.translator.level.BiomeTranslator;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.geysermc.mcprotocollib.protocol.data.game.RegistryEntry;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatType;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundRegistryDataPacket;

public final class RegistryCache {
    private static final Map<Key, Map<Key, NbtMap>> DEFAULTS;
    private static final Map<Key, BiConsumer<RegistryCache, List<RegistryEntry>>> REGISTRIES;
    private final GeyserSession session;
    private int[] biomeTranslations;
    private final JavaRegistry<ChatType> chatTypes = new SimpleJavaRegistry<ChatType>();
    private final JavaRegistry<JavaDimension> dimensions = new SimpleJavaRegistry<JavaDimension>();
    private final JavaRegistry<Enchantment> enchantments = new SimpleJavaRegistry<Enchantment>();
    private final JavaRegistry<JukeboxSong> jukeboxSongs = new SimpleJavaRegistry<JukeboxSong>();
    private final JavaRegistry<PaintingType> paintings = new SimpleJavaRegistry<PaintingType>();
    private final JavaRegistry<TrimMaterial> trimMaterials = new SimpleJavaRegistry<TrimMaterial>();
    private final JavaRegistry<TrimPattern> trimPatterns = new SimpleJavaRegistry<TrimPattern>();
    private final JavaRegistry<BannerPattern> bannerPatterns = new SimpleJavaRegistry<BannerPattern>();
    private final JavaRegistry<WolfEntity.BuiltInWolfVariant> wolfVariants = new SimpleJavaRegistry<WolfEntity.BuiltInWolfVariant>();
    private final JavaRegistry<GeyserInstrument> instruments = new SimpleJavaRegistry<GeyserInstrument>();

    public RegistryCache(GeyserSession session) {
        this.session = session;
    }

    public void load(ClientboundRegistryDataPacket packet) {
        BiConsumer<RegistryCache, List<RegistryEntry>> reader = REGISTRIES.get(packet.getRegistry());
        if (reader != null) {
            reader.accept(this, packet.getEntries());
        } else {
            GeyserImpl.getInstance().getLogger().debug("Ignoring registry of type " + String.valueOf(packet.getRegistry()));
        }
    }

    private static <T> void register(String registry, Function<RegistryCache, JavaRegistry<T>> localCacheFunction, Function<RegistryEntryContext, T> reader) {
        RegistryCache.register(MinecraftKey.key(registry), localCacheFunction, reader);
    }

    private static <T> void register(JavaRegistryKey<?> registry, Function<RegistryCache, JavaRegistry<T>> localCacheFunction, Function<RegistryEntryContext, T> reader) {
        RegistryCache.register(registry.registryKey(), localCacheFunction, reader);
    }

    private static <T> void register(Key registry, Function<RegistryCache, JavaRegistry<T>> localCacheFunction, Function<RegistryEntryContext, T> reader) {
        REGISTRIES.put(registry, (registryCache, entries) -> {
            Map<Key, NbtMap> localRegistry = null;
            JavaRegistry localCache = (JavaRegistry)localCacheFunction.apply((RegistryCache)registryCache);
            Object2IntOpenHashMap entryIdMap = new Object2IntOpenHashMap();
            for (int i = 0; i < entries.size(); ++i) {
                entryIdMap.put((Object)((RegistryEntry)entries.get(i)).getId(), i);
            }
            ArrayList builder = new ArrayList(entries.size());
            for (int i = 0; i < entries.size(); ++i) {
                RegistryEntry entry = (RegistryEntry)entries.get(i);
                if (entry.getData() == null) {
                    if (localRegistry == null) {
                        localRegistry = DEFAULTS.get(registry);
                    }
                    entry = new RegistryEntry(entry.getId(), localRegistry.get(entry.getId()));
                }
                RegistryEntryContext context = new RegistryEntryContext(entry, (Object2IntMap<Key>)entryIdMap, registryCache.session);
                Object cacheEntry = reader.apply(context);
                builder.add(i, cacheEntry);
            }
            localCache.reset(builder);
        });
    }

    private static void register(String registry, BiConsumer<RegistryCache, int[]> localCacheFunction, ToIntFunction<RegistryEntry> reader) {
        REGISTRIES.put(MinecraftKey.key(registry), (registryCache, entries) -> {
            Int2IntOpenHashMap temp = new Int2IntOpenHashMap();
            int greatestId = 0;
            for (int i = 0; i < entries.size(); ++i) {
                RegistryEntry entry = (RegistryEntry)entries.get(i);
                int cacheEntry = reader.applyAsInt(entry);
                temp.put(i, cacheEntry);
                if (i <= greatestId) continue;
                greatestId = i;
            }
            int[] array = new int[greatestId + 1];
            for (Int2IntMap.Entry entry : temp.int2IntEntrySet()) {
                array[entry.getIntKey()] = entry.getIntValue();
            }
            localCacheFunction.accept((RegistryCache)registryCache, array);
        });
    }

    public static void init() {
    }

    public int[] biomeTranslations() {
        return this.biomeTranslations;
    }

    public JavaRegistry<ChatType> chatTypes() {
        return this.chatTypes;
    }

    public JavaRegistry<JavaDimension> dimensions() {
        return this.dimensions;
    }

    public JavaRegistry<Enchantment> enchantments() {
        return this.enchantments;
    }

    public JavaRegistry<JukeboxSong> jukeboxSongs() {
        return this.jukeboxSongs;
    }

    public JavaRegistry<PaintingType> paintings() {
        return this.paintings;
    }

    public JavaRegistry<TrimMaterial> trimMaterials() {
        return this.trimMaterials;
    }

    public JavaRegistry<TrimPattern> trimPatterns() {
        return this.trimPatterns;
    }

    public JavaRegistry<BannerPattern> bannerPatterns() {
        return this.bannerPatterns;
    }

    public JavaRegistry<WolfEntity.BuiltInWolfVariant> wolfVariants() {
        return this.wolfVariants;
    }

    public JavaRegistry<GeyserInstrument> instruments() {
        return this.instruments;
    }

    static {
        REGISTRIES = new HashMap<Key, BiConsumer<RegistryCache, List<RegistryEntry>>>();
        RegistryCache.register("chat_type", (RegistryCache cache) -> cache.chatTypes, ChatDecoration::readChatType);
        RegistryCache.register("dimension_type", (RegistryCache cache) -> cache.dimensions, JavaDimension::read);
        RegistryCache.register(JavaRegistries.ENCHANTMENT, (RegistryCache cache) -> cache.enchantments, Enchantment::read);
        RegistryCache.register("instrument", (RegistryCache cache) -> cache.instruments, GeyserInstrument::read);
        RegistryCache.register("jukebox_song", (RegistryCache cache) -> cache.jukeboxSongs, JukeboxSong::read);
        RegistryCache.register("painting_variant", (RegistryCache cache) -> cache.paintings, (RegistryEntryContext context) -> PaintingType.getByName(context.id()));
        RegistryCache.register("trim_material", (RegistryCache cache) -> cache.trimMaterials, TrimRecipe::readTrimMaterial);
        RegistryCache.register("trim_pattern", (RegistryCache cache) -> cache.trimPatterns, TrimRecipe::readTrimPattern);
        RegistryCache.register("worldgen/biome", (RegistryCache cache, int[] array) -> {
            cache.biomeTranslations = array;
        }, BiomeTranslator::loadServerBiome);
        RegistryCache.register("banner_pattern", (RegistryCache cache) -> cache.bannerPatterns, (RegistryEntryContext context) -> BannerPattern.getByJavaIdentifier(context.id()));
        RegistryCache.register("wolf_variant", (RegistryCache cache) -> cache.wolfVariants, (RegistryEntryContext context) -> WolfEntity.BuiltInWolfVariant.getByJavaIdentifier(context.id().asString()));
        NbtMap tag = MinecraftProtocol.loadNetworkCodec();
        HashMap defaults = new HashMap();
        REGISTRIES.forEach((key, $) -> {
            List rawValues = tag.getCompound(key.asString()).getList("value", NbtType.COMPOUND);
            HashMap<Key, NbtMap> values = new HashMap<Key, NbtMap>();
            for (NbtMap value : rawValues) {
                Key name = MinecraftKey.key(value.getString("name"));
                values.put(name, value.getCompound("element"));
            }
            defaults.put(key, Map.copyOf(values));
        });
        DEFAULTS = Map.copyOf(defaults);
    }
}

