/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.concurrent.TimeUnit;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.MerchantContainer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ContainerClosePacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.NetworkStackLatencyPacket;
import org.geysermc.geyser.translator.inventory.MerchantInventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.java.inventory.JavaMerchantOffersTranslator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ContainerClosePacket.class)
public class BedrockContainerCloseTranslator
extends PacketTranslator<ContainerClosePacket> {
    @Override
    public void translate(GeyserSession session, ContainerClosePacket packet) {
        GeyserImpl.getInstance().getLogger().debug(session, packet.toString(), new Object[0]);
        byte bedrockId = packet.getId();
        session.sendUpstreamPacket(packet);
        session.setClosingInventory(false);
        Inventory openInventory = session.getOpenInventory();
        if (bedrockId == -1 && openInventory != null) {
            if (openInventory.getTranslator() instanceof MerchantInventoryTranslator) {
                bedrockId = (byte)openInventory.getBedrockId();
            } else if (openInventory.getBedrockId() == session.getPendingOrCurrentBedrockInventoryId()) {
                if (session.getContainerOpenAttempts() < 3) {
                    openInventory.setPending(true);
                    session.scheduleInEventLoop(() -> {
                        NetworkStackLatencyPacket latencyPacket = new NetworkStackLatencyPacket();
                        latencyPacket.setFromServer(true);
                        latencyPacket.setTimestamp(-9876543210L);
                        session.sendUpstreamPacket(latencyPacket);
                        GeyserImpl.getInstance().getLogger().debug(session, "Unable to open a virtual inventory, sent another latency packet!", new Object[0]);
                    }, 100L, TimeUnit.MILLISECONDS);
                    return;
                }
                GeyserImpl.getInstance().getLogger().debug(session, "Exceeded 3 attempts to open a virtual inventory!", new Object[0]);
                GeyserImpl.getInstance().getLogger().debug(session, String.valueOf(packet) + " " + session.getOpenInventory().getClass().getSimpleName(), new Object[0]);
            }
        }
        session.setPendingOrCurrentBedrockInventoryId(-1);
        session.setContainerOpenAttempts(0);
        this.closeCurrentOrOpenPending(session, bedrockId, openInventory);
    }

    private void closeCurrentOrOpenPending(GeyserSession session, byte bedrockId, Inventory openInventory) {
        if (openInventory != null) {
            if (bedrockId == openInventory.getBedrockId()) {
                InventoryUtils.sendJavaContainerClose(session, openInventory);
                InventoryUtils.closeInventory(session, openInventory.getJavaId(), false);
            } else if (openInventory.isPending()) {
                MerchantContainer merchantContainer;
                InventoryUtils.displayInventory(session, openInventory);
                if (openInventory instanceof MerchantContainer && (merchantContainer = (MerchantContainer)openInventory).getPendingOffersPacket() != null) {
                    JavaMerchantOffersTranslator.openMerchant(session, merchantContainer.getPendingOffersPacket(), merchantContainer);
                }
            }
        }
    }
}

