/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.util.DimensionUtils;

public record JavaDimension(int minY, int maxY, boolean piglinSafe, boolean ultrawarm, double worldCoordinateScale, int bedrockId, boolean isNetherLike) {
    public static JavaDimension read(RegistryEntryContext entry) {
        boolean isNetherLike;
        int bedrockId;
        NbtMap dimension = entry.data();
        int minY = dimension.getInt("min_y");
        int maxY = dimension.getInt("height");
        boolean piglinSafe = dimension.getBoolean("piglin_safe");
        boolean ultrawarm = dimension.getBoolean("ultrawarm");
        double coordinateScale = dimension.getNumber("coordinate_scale").doubleValue();
        Key id = entry.id();
        if ("minecraft".equals(id.namespace())) {
            String identifier = id.asString();
            bedrockId = DimensionUtils.javaToBedrock(identifier);
            isNetherLike = "minecraft:the_nether".equals(identifier);
        } else {
            String effects = dimension.getString("effects");
            bedrockId = DimensionUtils.javaToBedrock(effects);
            isNetherLike = "minecraft:the_nether".equals(effects);
        }
        if (minY % 16 != 0) {
            throw new RuntimeException("Minimum Y must be a multiple of 16!");
        }
        if (maxY % 16 != 0) {
            throw new RuntimeException("Maximum Y must be a multiple of 16!");
        }
        return new JavaDimension(minY, maxY, piglinSafe, ultrawarm, coordinateScale, bedrockId, isNetherLike);
    }
}

