/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.stream.Stream;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.session.GeyserSession;

public class InvalidPacketHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "rak-error-handler";
    private final GeyserSession session;

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable rootCause = Stream.iterate(cause, Throwable::getCause).filter(element -> element.getCause() == null).findFirst().orElse(cause);
        GeyserLogger logger = GeyserImpl.getInstance().getLogger();
        if (!(rootCause instanceof IllegalArgumentException)) {
            logger.warning("Exception caught in session of" + this.session.bedrockUsername() + ": " + rootCause.getMessage());
            this.session.disconnect("An internal error occurred!");
            return;
        }
        logger.warning("Illegal packet from " + this.session.bedrockUsername() + ": " + rootCause.getMessage());
        if (logger.isDebug()) {
            cause.printStackTrace();
        }
        this.session.disconnect("Invalid packet received!");
    }

    public InvalidPacketHandler(GeyserSession session) {
        this.session = session;
    }
}

