/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.item;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.components.Rarity;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TextComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TranslatableComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.CustomSkull;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.item.CustomItemTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.ModifierOperation;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AdventureModePredicate;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemAttributeModifiers;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.MobEffectDetails;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.MobEffectInstance;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WrittenBookContent;

public final class ItemTranslator {
    private static final EnumMap<ItemAttributeModifiers.EquipmentSlotGroup, String> SLOT_NAMES;
    private static final ItemAttributeModifiers.EquipmentSlotGroup[] ARMOR_SLOT_NAMES;
    private static final DecimalFormat ATTRIBUTE_FORMAT;
    private static final Key BASE_ATTACK_DAMAGE_ID;
    private static final Key BASE_ATTACK_SPEED_ID;
    private static final List<Item> GLINT_PRESENT;
    private static final List<Effect> negativeEffectList;

    private ItemTranslator() {
    }

    public static ItemStack translateToJava(GeyserSession session, ItemData data) {
        if (data == null) {
            return new ItemStack(Items.AIR_ID);
        }
        ItemMapping bedrockItem = session.getItemMappings().getMapping(data);
        Item javaItem = bedrockItem.getJavaItem();
        GeyserItemStack itemStack = javaItem.translateToJava(session, data, bedrockItem, session.getItemMappings());
        NbtMap nbt = data.getTag();
        if (nbt != null && !nbt.isEmpty()) {
            DataComponents components = itemStack.getOrCreateComponents();
            javaItem.translateNbtToJava(session, nbt, components, bedrockItem);
            if (!components.getDataComponents().isEmpty()) {
                itemStack.setComponents(components);
            }
        }
        return itemStack.getItemStack();
    }

    public static @NonNull ItemData.Builder translateToBedrock(GeyserSession session, int javaId, int count, DataComponents components) {
        ItemMapping bedrockItem = session.getItemMappings().getMapping(javaId);
        if (bedrockItem == ItemMapping.AIR) {
            session.getGeyser().getLogger().debug("ItemMapping returned air: " + javaId);
            return ItemData.builder();
        }
        return ItemTranslator.translateToBedrock(session, (Item)((List)Registries.JAVA_ITEMS.get()).get(javaId), bedrockItem, count, components);
    }

    public static @NonNull ItemData translateToBedrock(GeyserSession session, ItemStack stack) {
        if (InventoryUtils.isEmpty(stack)) {
            return ItemData.AIR;
        }
        ItemMapping bedrockItem = session.getItemMappings().getMapping(stack);
        if (bedrockItem == ItemMapping.AIR) {
            session.getGeyser().getLogger().debug("ItemMapping returned air: " + String.valueOf(stack));
            return ItemData.AIR;
        }
        return ItemTranslator.translateToBedrock(session, (Item)((List)Registries.JAVA_ITEMS.get()).get(stack.getId()), bedrockItem, stack.getAmount(), stack.getDataComponentsPatch()).build();
    }

    public static @NonNull ItemData.Builder translateToBedrock(GeyserSession session, Item javaItem, ItemMapping bedrockItem, int count, @Nullable DataComponents customComponents) {
        BedrockItemBuilder nbtBuilder = new BedrockItemBuilder();
        DataComponents components = javaItem.gatherComponents(customComponents);
        javaItem.translateComponentsToBedrock(session, components, nbtBuilder);
        Rarity rarity = Rarity.fromId(components.get(DataComponentTypes.RARITY));
        Object customName = ItemTranslator.getCustomName(session, customComponents, bedrockItem, rarity.getColor(), false, false);
        if (customName != null) {
            PotionContents potionContents = components.get(DataComponentTypes.POTION_CONTENTS);
            if (potionContents != null && components.get(DataComponentTypes.HIDE_ADDITIONAL_TOOLTIP) == null) {
                customName = (String)customName + ItemTranslator.getPotionEffectInfo(potionContents, session.locale());
            }
            nbtBuilder.setCustomName((String)customName);
        }
        boolean hideTooltips = components.get(DataComponentTypes.HIDE_TOOLTIP) != null;
        ItemAttributeModifiers attributeModifiers = components.get(DataComponentTypes.ATTRIBUTE_MODIFIERS);
        if (attributeModifiers != null && attributeModifiers.isShowInTooltip() && !hideTooltips) {
            ItemTranslator.addAttributeLore(session, attributeModifiers, nbtBuilder, session.locale());
        }
        if (session.isAdvancedTooltips() && !hideTooltips) {
            ItemTranslator.addAdvancedTooltips(components, nbtBuilder, javaItem, session.locale());
        }
        if (components.getOrDefault(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, false).booleanValue() && !GLINT_PRESENT.contains(javaItem)) {
            NbtMapBuilder nbtMapBuilder = nbtBuilder.getOrCreateNbt();
            nbtMapBuilder.putIfAbsent("ench", NbtList.EMPTY);
        }
        ItemData.Builder builder = javaItem.translateToBedrock(session, count, components, bedrockItem, session.getItemMappings());
        builder.tag(nbtBuilder.build());
        if (bedrockItem.isBlock()) {
            CustomBlockData customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(bedrockItem.getJavaItem().javaIdentifier(), null);
            if (customBlockData != null) {
                ItemTranslator.translateCustomBlock(customBlockData, session, builder);
            } else {
                builder.blockDefinition(bedrockItem.getBedrockBlockDefinition());
            }
        }
        if (bedrockItem.getJavaItem().equals(Items.PLAYER_HEAD)) {
            ItemTranslator.translatePlayerHead(session, components.get(DataComponentTypes.PROFILE), builder);
        }
        ItemTranslator.translateCustomItem(components, builder, bedrockItem);
        AdventureModePredicate canDestroy = components.get(DataComponentTypes.CAN_BREAK);
        AdventureModePredicate canPlaceOn = components.get(DataComponentTypes.CAN_PLACE_ON);
        String[] canBreak = ItemTranslator.getCanModify(session, canDestroy);
        String[] canPlace = ItemTranslator.getCanModify(session, canPlaceOn);
        if (canBreak != null) {
            builder.canBreak(canBreak);
        }
        if (canPlace != null) {
            builder.canPlace(canPlace);
        }
        return builder;
    }

    private static void addAttributeLore(GeyserSession session, ItemAttributeModifiers modifiers, BedrockItemBuilder builder, String language) {
        HashMap<ItemAttributeModifiers.EquipmentSlotGroup, List> slotsToModifiers = new HashMap<ItemAttributeModifiers.EquipmentSlotGroup, List>();
        for (ItemAttributeModifiers.Entry entry : modifiers.getModifiers()) {
            String loreEntry = ItemTranslator.attributeToLore(session, entry.getAttribute(), entry.getModifier(), language);
            if (loreEntry == null) continue;
            slotsToModifiers.computeIfAbsent(entry.getSlot(), s -> new ArrayList()).add(loreEntry);
        }
        for (ItemAttributeModifiers.EquipmentSlotGroup slot : SLOT_NAMES.keySet()) {
            List modifierStrings = (List)slotsToModifiers.get((Object)slot);
            if (modifierStrings == null || modifierStrings.isEmpty()) continue;
            Object slotComponent = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(NamedTextColor.GRAY)).append(Component.newline(), Component.translatable("item.modifiers." + SLOT_NAMES.get((Object)slot)))).build();
            builder.getOrCreateLore().add(MessageTranslator.convertMessage((Component)slotComponent, language));
            for (String modifier : modifierStrings) {
                builder.getOrCreateLore().add(modifier);
            }
        }
    }

    private static @Nullable String attributeToLore(GeyserSession session, int attribute, ItemAttributeModifiers.AttributeModifier modifier, String language) {
        String operationTotal;
        double amount = modifier.getAmount();
        if (amount == 0.0) {
            return null;
        }
        String name = AttributeType.Builtin.from(attribute).getIdentifier().asMinimalString();
        ModifierOperation operation = modifier.getOperation();
        boolean baseModifier = false;
        switch (operation) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ADD: {
                if (name.equals("knockback_resistance")) {
                    amount *= 10.0;
                }
                if (modifier.getId().equals(BASE_ATTACK_DAMAGE_ID)) {
                    amount += (double)session.getPlayerEntity().attributeOrDefault(GeyserAttributeType.ATTACK_DAMAGE);
                    baseModifier = true;
                } else if (modifier.getId().equals(BASE_ATTACK_SPEED_ID)) {
                    amount += (double)session.getPlayerEntity().attributeOrDefault(GeyserAttributeType.ATTACK_SPEED);
                    baseModifier = true;
                }
                Object object = ATTRIBUTE_FORMAT.format(amount);
                break;
            }
            case ADD_MULTIPLIED_BASE: 
            case ADD_MULTIPLIED_TOTAL: {
                Object object = operationTotal = ATTRIBUTE_FORMAT.format(amount * 100.0) + "%";
            }
        }
        if (amount > 0.0 && !baseModifier) {
            operationTotal = "+" + operationTotal;
        }
        Object attributeComponent = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(baseModifier ? NamedTextColor.DARK_GREEN : (amount > 0.0 ? NamedTextColor.BLUE : NamedTextColor.RED))).append(Component.text(" " + operationTotal + " "), Component.translatable("attribute.name." + name))).build();
        return MessageTranslator.convertMessage((Component)attributeComponent, language);
    }

    public static String getPotionEffectInfo(PotionContents contents, String language) {
        StringBuilder finalText = new StringBuilder();
        List<MobEffectInstance> effectInstanceList = contents.getCustomEffects();
        for (MobEffectInstance effectInstance : effectInstanceList) {
            Effect effect = effectInstance.getEffect();
            MobEffectDetails details = effectInstance.getDetails();
            int amplifier = details.getAmplifier();
            int durations = details.getDuration();
            TranslatableComponent appendTranslatable = Component.translatable("effect.minecraft." + effect.toString().toLowerCase(Locale.ROOT));
            if (amplifier != 0) {
                appendTranslatable = Component.translatable("potion.withAmplifier", appendTranslatable, Component.translatable("potion.potency." + amplifier));
            }
            if (durations > 20) {
                int seconds = durations / 20;
                int secondsFormat = seconds % 60;
                int minutes = seconds / 60;
                int minutesFormat = minutes % 60;
                int hours = minutes / 60;
                String text = (minutesFormat > 9 ? "" : "0") + minutesFormat + ":" + (secondsFormat > 9 ? "" : "0") + secondsFormat;
                if (minutes >= 60) {
                    text = (hours > 9 ? "" : "0") + hours + ":" + text;
                }
                appendTranslatable = Component.translatable("potion.withDuration", appendTranslatable, Component.text(text));
            } else if (durations == -1) {
                appendTranslatable = Component.translatable("potion.withDuration", appendTranslatable, Component.translatable("effect.duration.infinite"));
            }
            Object component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(negativeEffectList.contains((Object)effect) ? NamedTextColor.RED : NamedTextColor.BLUE)).append((Component)appendTranslatable)).build();
            finalText.append('\n').append(MessageTranslator.convertMessage((Component)component, language));
        }
        return finalText.toString();
    }

    public static String getPotionName(PotionContents contents, ItemMapping mapping, boolean hideAdditionalTooltip, String language) {
        String customPotionName = contents.getCustomName();
        Potion potion = Potion.getByJavaId(contents.getPotionId());
        if (customPotionName != null) {
            return MessageTranslator.convertMessage(Component.translatable(mapping.getJavaItem().translationKey() + ".effect." + customPotionName), language);
        }
        if (!hideAdditionalTooltip && !contents.getCustomEffects().isEmpty()) {
            String potionName;
            if (potion != null) {
                potionName = potion.toString().toLowerCase(Locale.ROOT);
                if (potionName.startsWith("strong_")) {
                    potionName = potionName.substring(6);
                } else if (potionName.startsWith("long_")) {
                    potionName = potionName.substring(4);
                }
            } else {
                potionName = "empty";
            }
            return MessageTranslator.convertMessage(Component.translatable(mapping.getJavaItem().translationKey() + ".effect." + potionName), language);
        }
        return null;
    }

    private static void addAdvancedTooltips(@Nullable DataComponents components, BedrockItemBuilder builder, Item item, String language) {
        int durability;
        Integer durabilityComponent;
        int maxDurability = item.defaultMaxDamage();
        if (maxDurability != 0 && components != null && (durabilityComponent = components.get(DataComponentTypes.DAMAGE)) != null && (durability = maxDurability - durabilityComponent) != maxDurability) {
            Object component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(NamedTextColor.WHITE)).append((Component)Component.translatable("item.durability", Component.text(durability), Component.text(maxDurability)))).build();
            builder.getOrCreateLore().add(MessageTranslator.convertMessage((Component)component, language));
        }
        builder.getOrCreateLore().add("\u00a7r\u00a78" + item.javaIdentifier());
        if (components != null) {
            Object component = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().resetStyle()).color(NamedTextColor.DARK_GRAY)).append((Component)Component.translatable("item.components", Component.text(components.getDataComponents().size())))).build();
            builder.getOrCreateLore().add(MessageTranslator.convertMessage((Component)component, language));
        }
    }

    private static String @Nullable [] getCanModify(GeyserSession session, @Nullable AdventureModePredicate canModifyJava) {
        if (canModifyJava == null) {
            return null;
        }
        List<AdventureModePredicate.BlockPredicate> predicates = canModifyJava.getPredicates();
        if (!predicates.isEmpty()) {
            ArrayList<String> canModifyBedrock = new ArrayList<String>();
            for (int i = 0; i < predicates.size(); ++i) {
                int[] holders;
                HolderSet holderSet = predicates.get(i).getBlocks();
                if (holderSet == null || (holders = holderSet.getHolders()) == null) continue;
                for (int blockId : holders) {
                    Block block = BlockRegistries.JAVA_BLOCKS.get(blockId);
                    if (block == null) continue;
                    String identifier = (String)session.getBlockMappings().getJavaToBedrockIdentifiers().get(block.javaId());
                    if (identifier == null) {
                        canModifyBedrock.add(block.javaIdentifier().value());
                        continue;
                    }
                    canModifyBedrock.add(identifier);
                }
            }
            return canModifyBedrock.toArray(new String[0]);
        }
        return null;
    }

    public static @NonNull ItemDefinition getBedrockItemDefinition(GeyserSession session, @NonNull GeyserItemStack itemStack) {
        ItemDefinition definition;
        CustomSkull customSkull;
        if (itemStack.isEmpty()) {
            return ItemDefinition.AIR;
        }
        ItemMapping mapping = itemStack.asItem().toBedrockDefinition(itemStack.getAllComponents(), session.getItemMappings());
        ItemDefinition itemDefinition = mapping.getBedrockDefinition();
        CustomBlockData customBlockData = BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.getOrDefault(mapping.getJavaItem().javaIdentifier(), null);
        if (customBlockData != null) {
            itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customBlockData);
        }
        if (mapping.getJavaItem().equals(Items.PLAYER_HEAD) && (customSkull = ItemTranslator.getCustomSkull(itemStack.getComponent(DataComponentTypes.PROFILE))) != null) {
            itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customSkull.getCustomBlockData());
        }
        if ((definition = CustomItemTranslator.getCustomItem(itemStack.getComponents(), mapping)) == null) {
            return itemDefinition;
        }
        return definition;
    }

    public static String getCustomName(GeyserSession session, DataComponents components, ItemMapping mapping, char translationColor, boolean customNameOnly, boolean includeAll) {
        if (components != null) {
            Component customName = components.get(DataComponentTypes.CUSTOM_NAME);
            if (customName != null) {
                return MessageTranslator.convertMessage(customName, session.locale());
            }
            if (!customNameOnly) {
                WrittenBookContent bookContent;
                String potionName;
                PotionContents potionContents = components.get(DataComponentTypes.POTION_CONTENTS);
                if (potionContents != null && (potionName = ItemTranslator.getPotionName(potionContents, mapping, components.get(DataComponentTypes.HIDE_ADDITIONAL_TOOLTIP) != null, session.locale())) != null) {
                    return "\u00a7r\u00a7" + translationColor + potionName;
                }
                if (includeAll && (bookContent = components.get(DataComponentTypes.WRITTEN_BOOK_CONTENT)) != null) {
                    return "\u00a7r\u00a7" + translationColor + bookContent.getTitle().getRaw();
                }
                customName = components.get(DataComponentTypes.ITEM_NAME);
                if (customName != null) {
                    return "\u00a7r\u00a7" + translationColor + MessageTranslator.convertMessage(customName, session.locale());
                }
            }
        }
        if (mapping.hasTranslation()) {
            String translationKey = mapping.getTranslationString();
            return "\u00a7r\u00a7" + translationColor + MinecraftLocale.getLocaleString(translationKey, session.locale());
        }
        return null;
    }

    public static void translateCustomItem(DataComponents components, ItemData.Builder builder, ItemMapping mapping) {
        ItemDefinition definition = CustomItemTranslator.getCustomItem(components, mapping);
        if (definition != null) {
            builder.definition(definition);
            builder.blockDefinition(null);
        }
    }

    private static void translateCustomBlock(CustomBlockData customBlockData, GeyserSession session, ItemData.Builder builder) {
        ItemDefinition itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customBlockData);
        BlockDefinition blockDefinition = (BlockDefinition)session.getBlockMappings().getCustomBlockStateDefinitions().get(customBlockData.defaultBlockState());
        builder.definition(itemDefinition);
        builder.blockDefinition(blockDefinition);
    }

    private static @Nullable CustomSkull getCustomSkull(@Nullable GameProfile profile) {
        Map<GameProfile.TextureType, GameProfile.Texture> textures;
        if (profile == null) {
            return null;
        }
        try {
            textures = profile.getTextures(false);
        }
        catch (IllegalStateException e) {
            GeyserImpl.getInstance().getLogger().debug("Could not decode player head from profile %s, got: %s".formatted(profile, e.getMessage()));
            return null;
        }
        if (textures == null || textures.isEmpty()) {
            return null;
        }
        GameProfile.Texture skinTexture = textures.get((Object)GameProfile.TextureType.SKIN);
        if (skinTexture == null) {
            return null;
        }
        String skinHash = skinTexture.getURL().substring(skinTexture.getURL().lastIndexOf(47) + 1);
        return (CustomSkull)BlockRegistries.CUSTOM_SKULLS.get(skinHash);
    }

    private static void translatePlayerHead(GeyserSession session, GameProfile profile, ItemData.Builder builder) {
        CustomSkull customSkull = ItemTranslator.getCustomSkull(profile);
        if (customSkull != null) {
            CustomBlockData customBlockData = customSkull.getCustomBlockData();
            ItemDefinition itemDefinition = (ItemDefinition)session.getItemMappings().getCustomBlockItemDefinitions().get(customBlockData);
            BlockDefinition blockDefinition = (BlockDefinition)session.getBlockMappings().getCustomBlockStateDefinitions().get(customBlockData.defaultBlockState());
            builder.definition(itemDefinition);
            builder.blockDefinition(blockDefinition);
        }
    }

    static {
        ARMOR_SLOT_NAMES = new ItemAttributeModifiers.EquipmentSlotGroup[]{ItemAttributeModifiers.EquipmentSlotGroup.HEAD, ItemAttributeModifiers.EquipmentSlotGroup.CHEST, ItemAttributeModifiers.EquipmentSlotGroup.LEGS, ItemAttributeModifiers.EquipmentSlotGroup.FEET};
        ATTRIBUTE_FORMAT = new DecimalFormat("0.#####");
        BASE_ATTACK_DAMAGE_ID = MinecraftKey.key("base_attack_damage");
        BASE_ATTACK_SPEED_ID = MinecraftKey.key("base_attack_speed");
        SLOT_NAMES = new EnumMap(ItemAttributeModifiers.EquipmentSlotGroup.class);
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.ANY, "any");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.MAIN_HAND, "mainhand");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.OFF_HAND, "offhand");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.HAND, "hand");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.FEET, "feet");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.LEGS, "legs");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.CHEST, "chest");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.HEAD, "head");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.ARMOR, "armor");
        SLOT_NAMES.put(ItemAttributeModifiers.EquipmentSlotGroup.BODY, "body");
        GLINT_PRESENT = List.of(Items.ENCHANTED_GOLDEN_APPLE, Items.EXPERIENCE_BOTTLE, Items.WRITTEN_BOOK, Items.NETHER_STAR, Items.ENCHANTED_BOOK, Items.END_CRYSTAL);
        negativeEffectList = List.of(Effect.SLOWNESS, Effect.MINING_FATIGUE, Effect.INSTANT_DAMAGE, Effect.NAUSEA, Effect.BLINDNESS, Effect.HUNGER, Effect.WEAKNESS, Effect.POISON, Effect.WITHER, Effect.LEVITATION, Effect.UNLUCK, Effect.DARKNESS, Effect.WIND_CHARGED, Effect.WEAVING, Effect.OOZING, Effect.INFESTED);
    }
}

