/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;

public class Instrument {
    private final Sound soundEvent;
    private final float useDuration;
    private final float range;
    private final Component description;

    public static @NonNull InstrumentBuilder builder() {
        return new InstrumentBuilder();
    }

    public @NonNull InstrumentBuilder toBuilder() {
        return new InstrumentBuilder().soundEvent(this.soundEvent).useDuration(this.useDuration).range(this.range).description(this.description);
    }

    public Sound getSoundEvent() {
        return this.soundEvent;
    }

    public float getUseDuration() {
        return this.useDuration;
    }

    public float getRange() {
        return this.range;
    }

    public Component getDescription() {
        return this.description;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Instrument)) {
            return false;
        }
        Instrument other = (Instrument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getUseDuration(), other.getUseDuration()) != 0) {
            return false;
        }
        if (Float.compare(this.getRange(), other.getRange()) != 0) {
            return false;
        }
        Sound this$soundEvent = this.getSoundEvent();
        Sound other$soundEvent = other.getSoundEvent();
        if (this$soundEvent == null ? other$soundEvent != null : !this$soundEvent.equals(other$soundEvent)) {
            return false;
        }
        Component this$description = this.getDescription();
        Component other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Instrument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getUseDuration());
        result = result * 59 + Float.floatToIntBits(this.getRange());
        Sound $soundEvent = this.getSoundEvent();
        result = result * 59 + ($soundEvent == null ? 43 : $soundEvent.hashCode());
        Component $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "Instrument(soundEvent=" + String.valueOf(this.getSoundEvent()) + ", useDuration=" + this.getUseDuration() + ", range=" + this.getRange() + ", description=" + String.valueOf(this.getDescription()) + ")";
    }

    public Instrument(Sound soundEvent, float useDuration, float range, Component description) {
        this.soundEvent = soundEvent;
        this.useDuration = useDuration;
        this.range = range;
        this.description = description;
    }

    public static class InstrumentBuilder {
        private Sound soundEvent;
        private float useDuration;
        private float range;
        private Component description;

        InstrumentBuilder() {
        }

        public @NonNull InstrumentBuilder soundEvent(Sound soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        public @NonNull InstrumentBuilder useDuration(float useDuration) {
            this.useDuration = useDuration;
            return this;
        }

        public @NonNull InstrumentBuilder range(float range) {
            this.range = range;
            return this;
        }

        public @NonNull InstrumentBuilder description(Component description) {
            this.description = description;
            return this;
        }

        public @NonNull Instrument build() {
            return new Instrument(this.soundEvent, this.useDuration, this.range, this.description);
        }

        public @NonNull String toString() {
            return "Instrument.InstrumentBuilder(soundEvent=" + String.valueOf(this.soundEvent) + ", useDuration=" + this.useDuration + ", range=" + this.range + ", description=" + String.valueOf(this.description) + ")";
        }
    }
}

