/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;
import org.jetbrains.annotations.UnmodifiableView;

public class Item {
    private static final Map<Block, Item> BLOCK_TO_ITEM = new HashMap<Block, Item>();
    protected final Key javaIdentifier;
    private int javaId = -1;
    private final int attackDamage;
    private DataComponents baseComponents;

    public Item(String javaIdentifier, Builder builder) {
        this.javaIdentifier = MinecraftKey.key(javaIdentifier);
        if (builder.components != null) {
            this.baseComponents = builder.components;
        }
        this.attackDamage = builder.attackDamage;
    }

    public String javaIdentifier() {
        return this.javaIdentifier.asString();
    }

    public Key javaKey() {
        return this.javaIdentifier;
    }

    public int javaId() {
        return this.javaId;
    }

    public int defaultMaxDamage() {
        return this.baseComponents.getOrDefault(DataComponentTypes.MAX_DAMAGE, 0);
    }

    public int defaultAttackDamage() {
        return this.attackDamage;
    }

    public int defaultMaxStackSize() {
        return this.baseComponents.getOrDefault(DataComponentTypes.MAX_STACK_SIZE, 1);
    }

    public @NonNull @UnmodifiableView DataComponents gatherComponents(@Nullable DataComponents others) {
        if (others == null) {
            return this.baseComponents;
        }
        DataComponents components = this.baseComponents.clone();
        components.getDataComponents().putAll(others.getDataComponents());
        return new DataComponents((Map<DataComponentType<?>, DataComponent<?, ?>>)ImmutableMap.copyOf(components.getDataComponents()));
    }

    public <T> @Nullable T getComponent(@NonNull DataComponentType<T> type) {
        return this.baseComponents.get(type);
    }

    public String translationKey() {
        return "item." + this.javaIdentifier.namespace() + "." + this.javaIdentifier.value();
    }

    public ItemData.Builder translateToBedrock(GeyserSession session, int count, DataComponents components, ItemMapping mapping, ItemMappings mappings) {
        if (this == Items.AIR || count <= 0) {
            return ItemData.builder();
        }
        return ItemData.builder().definition(mapping.getBedrockDefinition()).damage(mapping.getBedrockData()).count(count);
    }

    public @NonNull GeyserItemStack translateToJava(GeyserSession session, @NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        return GeyserItemStack.of(this.javaId, itemData.getCount());
    }

    public ItemMapping toBedrockDefinition(DataComponents components, ItemMappings mappings) {
        return mappings.getMapping(this.javaId);
    }

    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        Integer repairCost;
        Integer damage;
        List<Component> loreComponents = components.get(DataComponentTypes.LORE);
        if (loreComponents != null && tooltip.showInTooltip(DataComponentTypes.LORE)) {
            List<String> lore = builder.getOrCreateLore();
            for (Component loreComponent : loreComponents) {
                lore.add(MessageTranslator.convertMessage(loreComponent, session.locale()));
            }
        }
        if ((damage = components.get(DataComponentTypes.DAMAGE)) != null) {
            builder.setDamage(damage);
        }
        ArrayList<NbtMap> enchantNbtList = new ArrayList<NbtMap>();
        ItemEnchantments enchantments = components.get(DataComponentTypes.ENCHANTMENTS);
        if (enchantments != null) {
            for (Map.Entry<Integer, Integer> enchantment : enchantments.getEnchantments().entrySet()) {
                NbtMap enchantNbt = this.remapEnchantment(session, enchantment.getKey(), enchantment.getValue(), builder);
                if (enchantNbt == null) continue;
                enchantNbtList.add(enchantNbt);
            }
        }
        if (!enchantNbtList.isEmpty()) {
            builder.putList("ench", NbtType.COMPOUND, enchantNbtList);
        }
        if ((repairCost = components.get(DataComponentTypes.REPAIR_COST)) != null && repairCost != 0) {
            builder.putInt("RepairCost", repairCost);
        }
        if (components.getDataComponents().containsKey(DataComponentTypes.UNBREAKABLE)) {
            builder.putByte("Unbreakable", (byte)1);
        }
        if (!this.baseComponents.equals(components)) {
            builder.putInt("GeyserHash", components.hashCode());
        }
    }

    public void translateNbtToJava(@NonNull GeyserSession session, @NonNull NbtMap bedrockTag, @NonNull DataComponents components, @NonNull ItemMapping mapping) {
    }

    protected final @Nullable NbtMap remapEnchantment(GeyserSession session, int enchantId, int level, BedrockItemBuilder builder) {
        Enchantment enchantment = session.getRegistryCache().registry(JavaRegistries.ENCHANTMENT).byId(enchantId);
        if (enchantment == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown Java enchantment while NBT item translating: " + enchantId);
            return null;
        }
        BedrockEnchantment bedrockEnchantment = enchantment.bedrockEnchantment();
        if (bedrockEnchantment == null) {
            String enchantmentTranslation = MinecraftLocale.getLocaleString(enchantment.description(), session.locale());
            this.addJavaOnlyEnchantment(session, builder, enchantmentTranslation, level);
            builder.addEnchantmentGlint();
            return null;
        }
        return NbtMap.builder().putShort("id", (short)bedrockEnchantment.ordinal()).putShort("lvl", (short)level).build();
    }

    private void addJavaOnlyEnchantment(GeyserSession session, BedrockItemBuilder builder, String enchantmentName, int level) {
        String lvlTranslation = MinecraftLocale.getLocaleString("enchantment.level." + level, session.locale());
        builder.getOrCreateLore().add(0, "\u00a7r\u00a77" + enchantmentName + " " + lvlTranslation);
    }

    protected final void translateDyedColor(DataComponents components, BedrockItemBuilder builder) {
        Integer dyedItemColor = components.get(DataComponentTypes.DYED_COLOR);
        if (dyedItemColor != null) {
            builder.putInt("customColor", dyedItemColor);
        }
    }

    public boolean ignoreDamage() {
        return false;
    }

    public GeyserItemStack newItemStack(int count, DataComponents components) {
        return GeyserItemStack.of(this.javaId, count, components);
    }

    public void setJavaId(int javaId) {
        if (this.javaId != -1) {
            throw new RuntimeException("Item ID has already been set!");
        }
        this.javaId = javaId;
        if (this.baseComponents == null) {
            this.baseComponents = Registries.DEFAULT_DATA_COMPONENTS.get(javaId);
        }
    }

    public String toString() {
        return "Item{javaIdentifier='" + String.valueOf(this.javaIdentifier) + "', javaId=" + this.javaId + "}";
    }

    public static @NonNull Item byBlock(Block block) {
        return BLOCK_TO_ITEM.getOrDefault(block, Items.AIR);
    }

    protected static void registerBlock(Block block, Item item) {
        BLOCK_TO_ITEM.put(block, item);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DataComponents components;
        private int attackDamage;

        public Builder attackDamage(double attackDamage) {
            this.attackDamage = (int)attackDamage;
            return this;
        }

        public Builder components(DataComponents components) {
            this.components = components;
            return this;
        }

        private Builder() {
        }
    }
}

