/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.horse;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.horse.ChestedHorseEntity;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class LlamaEntity
extends ChestedHorseEntity {
    private int strength = 1;

    public LlamaEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityDataTypes.CONTAINER_STRENGTH_MODIFIER, 3);
    }

    public void setStrength(IntEntityMetadata entityMetadata) {
        this.strength = MathUtils.constrain(entityMetadata.getPrimitiveValue(), 1, 5);
        this.dirtyMetadata.put(EntityDataTypes.STRENGTH, this.strength);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.LLAMA_FOOD;
    }

    @Override
    protected boolean canUseSlot(EquipmentSlot slot) {
        return true;
    }

    public int getStrength() {
        return this.strength;
    }
}

