/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v557;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.EntityDataTypeMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.v554.BedrockCodecHelper_v554;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.Ability;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityProperties;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.FloatEntityProperty;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.IntEntityProperty;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.TextProcessingEventOrigin;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.AutoCraftRecipeAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.TypeMap;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;

public class BedrockCodecHelper_v557
extends BedrockCodecHelper_v554 {
    public BedrockCodecHelper_v557(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes, TypeMap<ItemStackRequestActionType> stackRequestActionTypes, TypeMap<ContainerSlotType> containerSlotTypes, TypeMap<Ability> abilities, TypeMap<TextProcessingEventOrigin> textProcessingEventOrigins) {
        super(entityData, gameRulesTypes, stackRequestActionTypes, containerSlotTypes, abilities, textProcessingEventOrigins);
    }

    @Override
    public void readEntityProperties(ByteBuf buffer, EntityProperties properties) {
        this.readArray(buffer, properties.getIntProperties(), (ByteBuf byteBuf) -> {
            int index = VarInts.readUnsignedInt(byteBuf);
            int value = VarInts.readInt(byteBuf);
            return new IntEntityProperty(index, value);
        });
        this.readArray(buffer, properties.getFloatProperties(), (ByteBuf byteBuf) -> {
            int index = VarInts.readUnsignedInt(byteBuf);
            float value = byteBuf.readFloatLE();
            return new FloatEntityProperty(index, value);
        });
    }

    @Override
    public void writeEntityProperties(ByteBuf buffer, EntityProperties properties) {
        this.writeArray(buffer, properties.getIntProperties(), (ByteBuf byteBuf, T property) -> {
            VarInts.writeUnsignedInt(byteBuf, property.getIndex());
            VarInts.writeInt(byteBuf, property.getValue());
        });
        this.writeArray(buffer, properties.getFloatProperties(), (ByteBuf byteBuf, T property) -> {
            VarInts.writeUnsignedInt(byteBuf, property.getIndex());
            byteBuf.writeFloatLE(property.getValue());
        });
    }

    @Override
    protected ItemStackRequestAction readRequestActionData(ByteBuf byteBuf, ItemStackRequestActionType type) {
        if (type == ItemStackRequestActionType.CRAFT_RECIPE_AUTO) {
            int recipeId = VarInts.readUnsignedInt(byteBuf);
            short timesCrafted = byteBuf.readUnsignedByte();
            ObjectArrayList ingredients = new ObjectArrayList();
            this.readArray(byteBuf, ingredients, ByteBuf::readUnsignedByte, (ByteBuf buf, BedrockCodecHelper helper) -> helper.readIngredient((ByteBuf)buf));
            return new AutoCraftRecipeAction(recipeId, timesCrafted, (List<ItemDescriptorWithCount>)ingredients, 0);
        }
        return super.readRequestActionData(byteBuf, type);
    }

    @Override
    protected void writeRequestActionData(ByteBuf byteBuf, ItemStackRequestAction action) {
        super.writeRequestActionData(byteBuf, action);
        if (action.getType() == ItemStackRequestActionType.CRAFT_RECIPE_AUTO) {
            List<ItemDescriptorWithCount> ingredients = ((AutoCraftRecipeAction)action).getIngredients();
            byteBuf.writeByte(ingredients.size());
            this.writeArray(byteBuf, ingredients, this::writeIngredient);
        }
    }
}

