/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.skin.Skin;
import org.geysermc.geyser.api.skin.SkinData;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.entity.type.player.SkullPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.skin.ImageData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.skin.SerializedSkin;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerSkinPacket;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;

public class SkullSkinManager
extends SkinManager {
    public static SerializedSkin buildSkullEntryManually(GeyserSession session, String skinId, byte[] skinData) {
        skinId = (String)skinId + "_skull";
        return SerializedSkin.builder().skinId((String)skinId).skinResourcePatch(SkinProvider.SKULL_GEOMETRY.geometryName()).skinData(ImageData.of(skinData)).capeData(ImageData.of(SkinProvider.EMPTY_CAPE.capeData())).geometryData(SkinProvider.SKULL_GEOMETRY.geometryData()).premium(true).capeId(SkinProvider.EMPTY_CAPE.capeId()).fullSkinId((String)skinId).geometryDataEngineVersion(session.getClientData().getGameVersion()).build();
    }

    public static void requestAndHandleSkin(AvatarEntity entity, GeyserSession session, Consumer<Skin> skinConsumer) {
        BiConsumer<Skin, Throwable> applySkin = (skin, throwable) -> {
            try {
                PlayerSkinPacket packet = new PlayerSkinPacket();
                packet.setUuid(entity.getUuid());
                packet.setOldSkinName("");
                packet.setNewSkinName(skin.textureUrl());
                packet.setSkin(SkullSkinManager.buildSkullEntryManually(session, skin.textureUrl(), skin.skinData()));
                packet.setTrustedSkin(true);
                session.sendUpstreamPacket(packet);
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.skin.fail", entity.getUuid()), e);
            }
            if (skinConsumer != null) {
                skinConsumer.accept((Skin)skin);
            }
        };
        SkinManager.GameProfileData data = SkinManager.GameProfileData.from(entity);
        if (data == null) {
            if (entity instanceof SkullPlayerEntity) {
                SkullPlayerEntity skullEntity = (SkullPlayerEntity)entity;
                GeyserImpl.getInstance().getLogger().debug("Using fallback skin for skull at " + String.valueOf(skullEntity.getSkullPosition()) + " with texture value: " + entity.getTexturesProperty() + " and UUID: " + String.valueOf(skullEntity.getSkullUUID()));
                SkinData fallback = SkinProvider.determineFallbackSkinData(skullEntity.getSkullUUID());
                applySkin.accept(fallback.skin(), null);
            }
        } else {
            SkinProvider.requestSkin(entity.getUuid(), data.skinUrl(), true).whenCompleteAsync((BiConsumer)applySkin);
        }
    }
}

