/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.FallingBlockData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.GenericObjectData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.MinecartType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.ObjectData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.ProjectileData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.WardenData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public class ClientboundAddEntityPacket
implements MinecraftPacket {
    private static final GenericObjectData EMPTY_DATA = new GenericObjectData(0);
    private final int entityId;
    @lombok.NonNull
    private final UUID uuid;
    @lombok.NonNull
    private final EntityType type;
    @lombok.NonNull
    private final ObjectData data;
    private final double x;
    private final double y;
    private final double z;
    private final Vector3d movement;
    private final float yaw;
    private final float headYaw;
    private final float pitch;

    public ClientboundAddEntityPacket(int entityId, @lombok.NonNull UUID uuid, @lombok.NonNull EntityType type, double x, double y, double z, float yaw, float pitch, float headYaw) {
        this(entityId, uuid, type, EMPTY_DATA, x, y, z, Vector3d.ZERO, yaw, headYaw, pitch);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public ClientboundAddEntityPacket(int entityId, @lombok.NonNull UUID uuid, @lombok.NonNull EntityType type, @lombok.NonNull ObjectData data, double x, double y, double z, float yaw, float pitch, float headYaw) {
        this(entityId, uuid, type, data, x, y, z, Vector3d.ZERO, yaw, headYaw, pitch);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
    }

    public ClientboundAddEntityPacket(int entityId, @lombok.NonNull UUID uuid, @lombok.NonNull EntityType type, double x, double y, double z, Vector3d movement, float yaw, float pitch, float headYaw) {
        this(entityId, uuid, type, EMPTY_DATA, x, y, z, movement, yaw, headYaw, pitch);
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public ClientboundAddEntityPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.uuid = MinecraftTypes.readUUID(in);
        this.type = EntityType.from(MinecraftTypes.readVarInt(in));
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.movement = MinecraftTypes.readLpVec3(in);
        this.pitch = (float)(in.readByte() * 360) / 256.0f;
        this.yaw = (float)(in.readByte() * 360) / 256.0f;
        this.headYaw = (float)(in.readByte() * 360) / 256.0f;
        int data = MinecraftTypes.readVarInt(in);
        this.data = this.type == EntityType.MINECART ? MinecartType.from(data) : (this.type == EntityType.ITEM_FRAME || this.type == EntityType.GLOW_ITEM_FRAME || this.type == EntityType.PAINTING ? Direction.VALUES[data] : (this.type == EntityType.FALLING_BLOCK ? new FallingBlockData(data & 0xFFFF, data >> 16) : (this.type.isProjectile() ? new ProjectileData(data) : (this.type == EntityType.WARDEN ? new WardenData(data) : (data == 0 ? EMPTY_DATA : new GenericObjectData(data))))));
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        MinecraftTypes.writeUUID(out, this.uuid);
        MinecraftTypes.writeVarInt(out, this.type.ordinal());
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        MinecraftTypes.writeLpVec3(out, this.movement);
        out.writeByte((int)((byte)(this.pitch * 256.0f / 360.0f)));
        out.writeByte((int)((byte)(this.yaw * 256.0f / 360.0f)));
        out.writeByte((int)((byte)(this.headYaw * 256.0f / 360.0f)));
        int data = 0;
        if (this.data instanceof MinecartType) {
            data = ((MinecartType)this.data).ordinal();
        } else if (this.data instanceof Direction) {
            data = ((Direction)this.data).ordinal();
        } else if (this.data instanceof FallingBlockData) {
            data = ((FallingBlockData)this.data).getId() | ((FallingBlockData)this.data).getMetadata() << 16;
        } else if (this.data instanceof ProjectileData) {
            data = ((ProjectileData)this.data).getOwnerId();
        } else if (this.data instanceof GenericObjectData) {
            data = ((GenericObjectData)this.data).getValue();
        }
        MinecraftTypes.writeVarInt(out, data);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @lombok.NonNull
    public UUID getUuid() {
        return this.uuid;
    }

    @lombok.NonNull
    public EntityType getType() {
        return this.type;
    }

    @lombok.NonNull
    public ObjectData getData() {
        return this.data;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3d getMovement() {
        return this.movement;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundAddEntityPacket)) {
            return false;
        }
        ClientboundAddEntityPacket other = (ClientboundAddEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getHeadYaw(), other.getHeadYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        ObjectData this$data = this.getData();
        ObjectData other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Vector3d this$movement = this.getMovement();
        Vector3d other$movement = other.getMovement();
        return !(this$movement == null ? other$movement != null : !this$movement.equals(other$movement));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundAddEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getHeadYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        ObjectData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Vector3d $movement = this.getMovement();
        result = result * 59 + ($movement == null ? 43 : $movement.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundAddEntityPacket(entityId=" + this.getEntityId() + ", uuid=" + String.valueOf(this.getUuid()) + ", type=" + String.valueOf((Object)this.getType()) + ", data=" + String.valueOf(this.getData()) + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", movement=" + String.valueOf(this.getMovement()) + ", yaw=" + this.getYaw() + ", headYaw=" + this.getHeadYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public @NonNull ClientboundAddEntityPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundAddEntityPacket(entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, this.movement, this.yaw, this.headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withUuid(@lombok.NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return this.uuid == uuid ? this : new ClientboundAddEntityPacket(this.entityId, uuid, this.type, this.data, this.x, this.y, this.z, this.movement, this.yaw, this.headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withType(@lombok.NonNull EntityType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.type == type ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, type, this.data, this.x, this.y, this.z, this.movement, this.yaw, this.headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withData(@lombok.NonNull ObjectData data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.data == data ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, data, this.x, this.y, this.z, this.movement, this.yaw, this.headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withX(double x) {
        return this.x == x ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, x, this.y, this.z, this.movement, this.yaw, this.headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withY(double y) {
        return this.y == y ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, y, this.z, this.movement, this.yaw, this.headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withZ(double z) {
        return this.z == z ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, z, this.movement, this.yaw, this.headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withMovement(Vector3d movement) {
        return this.movement == movement ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, movement, this.yaw, this.headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, this.movement, yaw, this.headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withHeadYaw(float headYaw) {
        return this.headYaw == headYaw ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, this.movement, this.yaw, headYaw, this.pitch);
    }

    public @NonNull ClientboundAddEntityPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundAddEntityPacket(this.entityId, this.uuid, this.type, this.data, this.x, this.y, this.z, this.movement, this.yaw, this.headYaw, pitch);
    }

    public ClientboundAddEntityPacket(int entityId, @lombok.NonNull UUID uuid, @lombok.NonNull EntityType type, @lombok.NonNull ObjectData data, double x, double y, double z, Vector3d movement, float yaw, float headYaw, float pitch) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.entityId = entityId;
        this.uuid = uuid;
        this.type = type;
        this.data = data;
        this.x = x;
        this.y = y;
        this.z = z;
        this.movement = movement;
        this.yaw = yaw;
        this.headYaw = headYaw;
        this.pitch = pitch;
    }
}

