/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Filterable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WritableBookContent;

public class WritableBookItem
extends Item {
    public WritableBookItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, builder);
        WritableBookContent bookContent = components.get(DataComponentTypes.WRITABLE_BOOK_CONTENT);
        if (bookContent == null) {
            return;
        }
        ArrayList<NbtMap> bedrockPages = new ArrayList<NbtMap>();
        for (Filterable<String> page : bookContent.getPages()) {
            NbtMapBuilder pageBuilder = NbtMap.builder();
            pageBuilder.putString("photoname", "");
            pageBuilder.putString("text", MessageTranslator.convertMessageLenient(page.getRaw()));
            bedrockPages.add(pageBuilder.build());
        }
        builder.putList("pages", NbtType.COMPOUND, bedrockPages);
    }
}

