/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class GoatEntity
extends AnimalEntity {
    private static final float LONG_JUMPING_HEIGHT = 0.90999997f;
    private static final float LONG_JUMPING_WIDTH = 0.63f;
    private boolean isScreamer;
    private boolean hasLeftHorn;
    private boolean hasRightHorn;

    public GoatEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setScreamer(BooleanEntityMetadata entityMetadata) {
        this.isScreamer = entityMetadata.getPrimitiveValue();
    }

    @Override
    protected void setDimensions(Pose pose) {
        if (pose == Pose.LONG_JUMPING) {
            this.setBoundingBoxWidth(0.63f);
            this.setBoundingBoxHeight(0.90999997f);
        } else {
            super.setDimensions(pose);
        }
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.getFlag(EntityFlag.BABY) && itemInHand.asItem() == Items.BUCKET) {
            this.session.playSoundEvent(this.isScreamer ? SoundEvent.MILK_SCREAMER : SoundEvent.MILK, this.position);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }

    public void setHasLeftHorn(BooleanEntityMetadata entityMetadata) {
        this.hasLeftHorn = entityMetadata.getPrimitiveValue();
        this.setHornCount();
    }

    public void setHasRightHorn(BooleanEntityMetadata entityMetadata) {
        this.hasRightHorn = entityMetadata.getPrimitiveValue();
        this.setHornCount();
    }

    private void setHornCount() {
        this.dirtyMetadata.put(EntityDataTypes.GOAT_HORN_COUNT, (this.hasLeftHorn ? 1 : 0) + (this.hasRightHorn ? 1 : 0));
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.GOAT_FOOD;
    }
}

