/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import java.util.Iterator;
import java.util.List;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.SignUtils;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.SIGN})
public class SignBlockEntityTranslator
extends BlockEntityTranslator {
    private int getBedrockSignColor(String javaColor) {
        int dyeColor = switch (javaColor) {
            case "white" -> 0xF9FFFE;
            case "orange" -> 16351261;
            case "magenta" -> 13061821;
            case "light_blue" -> 3847130;
            case "yellow" -> 16701501;
            case "lime" -> 8439583;
            case "pink" -> 15961002;
            case "gray" -> 4673362;
            case "light_gray" -> 0x9D9D97;
            case "cyan" -> 1481884;
            case "purple" -> 8991416;
            case "blue" -> 3949738;
            case "brown" -> 8606770;
            case "green" -> 6192150;
            case "red" -> 11546150;
            default -> 0;
        };
        return dyeColor | 0xFF000000;
    }

    public int signWidthMax() {
        return 90;
    }

    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        bedrockNbt.putCompound("FrontText", this.translateSide(javaNbt.getCompound("front_text")));
        bedrockNbt.putCompound("BackText", this.translateSide(javaNbt.getCompound("back_text")));
        bedrockNbt.putBoolean("IsWaxed", javaNbt.getBoolean("is_waxed"));
    }

    private NbtMap translateSide(NbtMap javaNbt) {
        NbtMapBuilder builder = NbtMap.builder();
        StringBuilder signText = new StringBuilder();
        List messages = javaNbt.getList("messages", NbtType.STRING);
        if (!messages.isEmpty()) {
            Iterator it = messages.iterator();
            while (it.hasNext()) {
                String signLine = (String)it.next();
                signLine = MessageTranslator.convertMessageLenient(signLine);
                int signWidth = 0;
                StringBuilder finalSignLine = new StringBuilder();
                boolean previousCharacterWasFormatting = false;
                for (char c : signLine.toCharArray()) {
                    if (c == '\u00a7') {
                        previousCharacterWasFormatting = true;
                    } else if (previousCharacterWasFormatting) {
                        previousCharacterWasFormatting = false;
                    } else {
                        signWidth += SignUtils.getCharacterWidth(c);
                    }
                    if (signWidth > this.signWidthMax()) break;
                    finalSignLine.append(c);
                }
                signText.append((CharSequence)finalSignLine);
                if (!it.hasNext()) continue;
                signText.append("\n");
            }
        }
        while (!signText.isEmpty() && signText.charAt(signText.length() - 1) == '\n') {
            signText.deleteCharAt(signText.length() - 1);
        }
        builder.putString("Text", signText.toString());
        String color = javaNbt.getString("color", null);
        if (color != null) {
            builder.putInt("SignTextColor", this.getBedrockSignColor(color));
        }
        boolean isGlowing = javaNbt.getBoolean("has_glowing_text");
        builder.putBoolean("IgnoreLighting", isGlowing);
        return builder.build();
    }
}

