/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.GlobalPos;

public class ClientboundSetDefaultSpawnPositionPacket
implements MinecraftPacket {
    private final GlobalPos globalPos;
    private final float yaw;
    private final float pitch;

    public ClientboundSetDefaultSpawnPositionPacket(ByteBuf in) {
        this.globalPos = MinecraftTypes.readGlobalPos(in);
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeGlobalPos(out, this.globalPos);
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public GlobalPos getGlobalPos() {
        return this.globalPos;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetDefaultSpawnPositionPacket)) {
            return false;
        }
        ClientboundSetDefaultSpawnPositionPacket other = (ClientboundSetDefaultSpawnPositionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        GlobalPos this$globalPos = this.getGlobalPos();
        GlobalPos other$globalPos = other.getGlobalPos();
        return !(this$globalPos == null ? other$globalPos != null : !this$globalPos.equals(other$globalPos));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetDefaultSpawnPositionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        GlobalPos $globalPos = this.getGlobalPos();
        result = result * 59 + ($globalPos == null ? 43 : $globalPos.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetDefaultSpawnPositionPacket(globalPos=" + String.valueOf(this.getGlobalPos()) + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public @NonNull ClientboundSetDefaultSpawnPositionPacket withGlobalPos(GlobalPos globalPos) {
        return this.globalPos == globalPos ? this : new ClientboundSetDefaultSpawnPositionPacket(globalPos, this.yaw, this.pitch);
    }

    public @NonNull ClientboundSetDefaultSpawnPositionPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ClientboundSetDefaultSpawnPositionPacket(this.globalPos, yaw, this.pitch);
    }

    public @NonNull ClientboundSetDefaultSpawnPositionPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundSetDefaultSpawnPositionPacket(this.globalPos, this.yaw, pitch);
    }

    public ClientboundSetDefaultSpawnPositionPacket(GlobalPos globalPos, float yaw, float pitch) {
        this.globalPos = globalPos;
        this.yaw = yaw;
        this.pitch = pitch;
    }
}

