/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerClosePacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.MerchantContainer;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.protocol.java.inventory.JavaMerchantOffersTranslator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ContainerClosePacket.class)
public class BedrockContainerCloseTranslator
extends PacketTranslator<ContainerClosePacket> {
    @Override
    public void translate(GeyserSession session, ContainerClosePacket packet) {
        Inventory openInventory;
        byte bedrockId = packet.getId();
        session.sendUpstreamPacket((BedrockPacket)packet);
        session.setClosingInventory(false);
        if (bedrockId == -1 && session.getOpenInventory() instanceof MerchantContainer) {
            bedrockId = (byte)session.getOpenInventory().getBedrockId();
        }
        if ((openInventory = session.getOpenInventory()) != null) {
            if (bedrockId == openInventory.getBedrockId()) {
                InventoryUtils.sendJavaContainerClose(session, openInventory);
                InventoryUtils.closeInventory(session, openInventory.getJavaId(), false);
            } else if (openInventory.isPending()) {
                MerchantContainer merchantContainer;
                InventoryUtils.displayInventory(session, openInventory);
                openInventory.setPending(false);
                if (openInventory instanceof MerchantContainer && (merchantContainer = (MerchantContainer)openInventory).getPendingOffersPacket() != null) {
                    JavaMerchantOffersTranslator.openMerchant(session, merchantContainer.getPendingOffersPacket(), merchantContainer);
                }
            }
        }
    }
}

