/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.biome;

import org.cloudburstmc.protocol.bedrock.data.ExpressionOp;
import org.cloudburstmc.protocol.bedrock.data.biome.BiomeSurfaceMaterialData;
import org.cloudburstmc.protocol.common.util.index.Indexable;
import org.cloudburstmc.protocol.common.util.index.Unindexed;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.annotation.JsonCreator;

public final class BiomeElementData {
    private final float noiseFrequencyScale;
    private final float noiseLowerBound;
    private final float noiseUpperBound;
    private final ExpressionOp heightMinType;
    private final transient Indexable<String> heightMin;
    private final ExpressionOp heightMaxType;
    private final transient Indexable<String> heightMax;
    private final BiomeSurfaceMaterialData adjustedMaterials;

    @JsonCreator
    public BiomeElementData(float noiseFrequencyScale, float noiseLowerBound, float noiseUpperBound, ExpressionOp heightMinType, String heightMin, ExpressionOp heightMaxType, String heightMax, BiomeSurfaceMaterialData adjustedMaterials) {
        this.noiseFrequencyScale = noiseFrequencyScale;
        this.noiseLowerBound = noiseLowerBound;
        this.noiseUpperBound = noiseUpperBound;
        this.heightMinType = heightMinType;
        this.heightMin = new Unindexed<String>(heightMin);
        this.heightMaxType = heightMaxType;
        this.heightMax = new Unindexed<String>(heightMax);
        this.adjustedMaterials = adjustedMaterials;
    }

    public String getHeightMin() {
        return this.heightMin.get();
    }

    public String getHeightMax() {
        return this.heightMax.get();
    }

    public float getNoiseFrequencyScale() {
        return this.noiseFrequencyScale;
    }

    public float getNoiseLowerBound() {
        return this.noiseLowerBound;
    }

    public float getNoiseUpperBound() {
        return this.noiseUpperBound;
    }

    public ExpressionOp getHeightMinType() {
        return this.heightMinType;
    }

    public ExpressionOp getHeightMaxType() {
        return this.heightMaxType;
    }

    public BiomeSurfaceMaterialData getAdjustedMaterials() {
        return this.adjustedMaterials;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiomeElementData)) {
            return false;
        }
        BiomeElementData other = (BiomeElementData)o;
        if (Float.compare(this.getNoiseFrequencyScale(), other.getNoiseFrequencyScale()) != 0) {
            return false;
        }
        if (Float.compare(this.getNoiseLowerBound(), other.getNoiseLowerBound()) != 0) {
            return false;
        }
        if (Float.compare(this.getNoiseUpperBound(), other.getNoiseUpperBound()) != 0) {
            return false;
        }
        ExpressionOp this$heightMinType = this.getHeightMinType();
        ExpressionOp other$heightMinType = other.getHeightMinType();
        if (this$heightMinType == null ? other$heightMinType != null : !((Object)((Object)this$heightMinType)).equals((Object)other$heightMinType)) {
            return false;
        }
        ExpressionOp this$heightMaxType = this.getHeightMaxType();
        ExpressionOp other$heightMaxType = other.getHeightMaxType();
        if (this$heightMaxType == null ? other$heightMaxType != null : !((Object)((Object)this$heightMaxType)).equals((Object)other$heightMaxType)) {
            return false;
        }
        BiomeSurfaceMaterialData this$adjustedMaterials = this.getAdjustedMaterials();
        BiomeSurfaceMaterialData other$adjustedMaterials = other.getAdjustedMaterials();
        return !(this$adjustedMaterials == null ? other$adjustedMaterials != null : !((Object)this$adjustedMaterials).equals(other$adjustedMaterials));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getNoiseFrequencyScale());
        result = result * 59 + Float.floatToIntBits(this.getNoiseLowerBound());
        result = result * 59 + Float.floatToIntBits(this.getNoiseUpperBound());
        ExpressionOp $heightMinType = this.getHeightMinType();
        result = result * 59 + ($heightMinType == null ? 43 : ((Object)((Object)$heightMinType)).hashCode());
        ExpressionOp $heightMaxType = this.getHeightMaxType();
        result = result * 59 + ($heightMaxType == null ? 43 : ((Object)((Object)$heightMaxType)).hashCode());
        BiomeSurfaceMaterialData $adjustedMaterials = this.getAdjustedMaterials();
        result = result * 59 + ($adjustedMaterials == null ? 43 : ((Object)$adjustedMaterials).hashCode());
        return result;
    }

    public String toString() {
        return "BiomeElementData(noiseFrequencyScale=" + this.getNoiseFrequencyScale() + ", noiseLowerBound=" + this.getNoiseLowerBound() + ", noiseUpperBound=" + this.getNoiseUpperBound() + ", heightMinType=" + (Object)((Object)this.getHeightMinType()) + ", heightMin=" + this.getHeightMin() + ", heightMaxType=" + (Object)((Object)this.getHeightMaxType()) + ", heightMax=" + this.getHeightMax() + ", adjustedMaterials=" + this.getAdjustedMaterials() + ")";
    }

    @Deprecated
    public BiomeElementData(float noiseFrequencyScale, float noiseLowerBound, float noiseUpperBound, ExpressionOp heightMinType, Indexable<String> heightMin, ExpressionOp heightMaxType, Indexable<String> heightMax, BiomeSurfaceMaterialData adjustedMaterials) {
        this.noiseFrequencyScale = noiseFrequencyScale;
        this.noiseLowerBound = noiseLowerBound;
        this.noiseUpperBound = noiseUpperBound;
        this.heightMinType = heightMinType;
        this.heightMin = heightMin;
        this.heightMaxType = heightMaxType;
        this.heightMax = heightMax;
        this.adjustedMaterials = adjustedMaterials;
    }
}

