/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.SoundMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;

public final class SoundUtils {
    public static @Nullable SoundEvent toSoundEvent(String sound) {
        try {
            return SoundEvent.valueOf(sound.toUpperCase(Locale.ROOT).replace(".", "_"));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String translatePlaySound(String javaIdentifier) {
        String soundIdentifier = SoundUtils.removeMinecraftNamespace(javaIdentifier);
        SoundMapping soundMapping = (SoundMapping)Registries.SOUNDS.get(soundIdentifier);
        if (soundMapping == null || soundMapping.playsound() == null) {
            GeyserImpl.getInstance().getLogger().debug("[PlaySound] Defaulting to sound server gave us for " + javaIdentifier);
            return soundIdentifier;
        }
        return soundMapping.playsound();
    }

    private static String removeMinecraftNamespace(String identifier) {
        if (identifier.startsWith("minecraft:")) {
            return identifier.substring("minecraft:".length());
        }
        return identifier;
    }

    private static void playSound(GeyserSession session, String bedrockName, Vector3f position, float volume, float pitch) {
        PlaySoundPacket playSoundPacket = new PlaySoundPacket();
        playSoundPacket.setSound(bedrockName);
        playSoundPacket.setPosition(position);
        playSoundPacket.setVolume(volume);
        playSoundPacket.setPitch(pitch);
        session.sendUpstreamPacket(playSoundPacket);
    }

    public static void playSound(GeyserSession session, Sound javaSound, Vector3f position, float volume, float pitch) {
        String soundIdentifier = SoundUtils.removeMinecraftNamespace(javaSound.getName());
        SoundMapping soundMapping = (SoundMapping)Registries.SOUNDS.get(soundIdentifier);
        if (soundMapping == null) {
            session.getGeyser().getLogger().debug("[Builtin] Sound mapping for " + soundIdentifier + " not found; assuming custom.");
            SoundUtils.playSound(session, soundIdentifier, position, volume, pitch);
            return;
        }
        if (soundMapping.playsound() != null) {
            SoundUtils.playSound(session, soundMapping.playsound(), position, volume, pitch * soundMapping.pitchAdjust());
            return;
        }
        if (soundMapping.levelEvent()) {
            LevelEventPacket levelEventPacket = new LevelEventPacket();
            levelEventPacket.setPosition(position);
            levelEventPacket.setData(0);
            levelEventPacket.setType(LevelEvent.valueOf(soundMapping.bedrock()));
            session.sendUpstreamPacket(levelEventPacket);
            return;
        }
        LevelSoundEventPacket soundPacket = new LevelSoundEventPacket();
        SoundEvent sound = SoundUtils.toSoundEvent(soundMapping.bedrock());
        if (sound == null) {
            sound = SoundUtils.toSoundEvent(soundIdentifier);
        }
        if (sound == null) {
            session.getGeyser().getLogger().debug("[Builtin] Sound for original '" + soundIdentifier + "' to mappings '" + soundMapping.bedrock() + "' was not a playable level sound, or has yet to be mapped to an enum in SoundEvent.");
            return;
        }
        soundPacket.setSound(sound);
        soundPacket.setPosition(position);
        soundPacket.setIdentifier(soundMapping.identifier());
        if (sound == SoundEvent.NOTE) {
            soundPacket.setExtraData(soundMapping.extraData() + (int)Math.round(Math.log10(pitch) / Math.log10(2.0) * 12.0) + 12);
        } else if (sound == SoundEvent.PLACE && soundMapping.extraData() == -1) {
            if (!soundMapping.identifier().equals(":")) {
                int javaId = ((Object2IntMap)BlockRegistries.JAVA_IDENTIFIER_TO_ID.get()).getOrDefault((Object)soundMapping.identifier(), 0);
                soundPacket.setExtraData(session.getBlockMappings().getBedrockBlockId(javaId));
            } else {
                session.getGeyser().getLogger().debug("PLACE sound mapping identifier was invalid! Please report: " + String.valueOf(soundMapping));
            }
            soundPacket.setIdentifier(":");
        } else {
            soundPacket.setExtraData(soundMapping.extraData());
        }
        soundPacket.setBabySound(false);
        soundPacket.setRelativeVolumeDisabled(false);
        session.sendUpstreamPacket(soundPacket);
    }

    public static String readSoundEvent(NbtMap data, String context) {
        String soundEvent;
        Object soundEventObject = data.get("sound_event");
        if (soundEventObject instanceof NbtMap) {
            NbtMap map = (NbtMap)soundEventObject;
            soundEvent = map.getString("sound_id");
        } else if (soundEventObject instanceof String) {
            String string;
            soundEvent = string = (String)soundEventObject;
        } else {
            soundEvent = "";
            GeyserImpl.getInstance().getLogger().debug("Sound event for " + context + " was of an unexpected type! Expected string or NBT map, got " + String.valueOf(soundEventObject));
        }
        return soundEvent;
    }

    private SoundUtils() {
    }
}

