/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.chunk;

import io.netty.buffer.ByteBuf;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntList;

public class BlockStorage {
    public static final int SIZE = 4096;
    private final IntList palette;
    private BitArray bitArray;

    public BlockStorage(int airBlockId) {
        this(airBlockId, BitArrayVersion.V2);
    }

    public BlockStorage(int airBlockId, BitArrayVersion version) {
        this.bitArray = version.createArray(4096);
        this.palette = new IntArrayList(16);
        this.palette.add(airBlockId);
    }

    public BlockStorage(BitArray bitArray, IntList palette) {
        this.palette = palette;
        this.bitArray = bitArray;
    }

    private static int getPaletteHeader(BitArrayVersion version, boolean runtime) {
        return version.getId() << 1 | (runtime ? 1 : 0);
    }

    public int getFullBlock(int index) {
        return this.palette.getInt(this.bitArray.get(index));
    }

    public void setFullBlock(int index, int runtimeId) {
        int idx = this.idFor(runtimeId);
        this.bitArray.set(index, idx);
    }

    public void writeToNetwork(ByteBuf buffer) {
        buffer.writeByte(BlockStorage.getPaletteHeader(this.bitArray.getVersion(), true));
        for (int word : this.bitArray.getWords()) {
            buffer.writeIntLE(word);
        }
        this.bitArray.writeSizeToNetwork(buffer, this.palette.size());
        this.palette.forEach(id -> VarInts.writeInt(buffer, id));
    }

    public int estimateNetworkSize() {
        int size = 1;
        size += this.bitArray.getWords().length * 4;
        size += 3;
        return size += this.palette.size() * 3;
    }

    private void onResize(BitArrayVersion version) {
        BitArray newBitArray = version.createArray(4096);
        for (int i = 0; i < 4096; ++i) {
            newBitArray.set(i, this.bitArray.get(i));
        }
        this.bitArray = newBitArray;
    }

    public int idFor(int runtimeId) {
        BitArrayVersion next;
        int index = this.palette.indexOf(runtimeId);
        if (index != -1) {
            return index;
        }
        index = this.palette.size();
        this.palette.add(runtimeId);
        BitArrayVersion version = this.bitArray.getVersion();
        if (index > version.getMaxEntryValue() && (next = version.next()) != null) {
            this.onResize(next);
        }
        return index;
    }

    public boolean isEmpty() {
        if (this.palette.size() == 1) {
            return true;
        }
        for (int word : this.bitArray.getWords()) {
            if (Integer.toUnsignedLong(word) == 0L) continue;
            return false;
        }
        return true;
    }

    public BlockStorage copy() {
        return new BlockStorage(this.bitArray.copy(), new IntArrayList(this.palette));
    }

    public IntList getPalette() {
        return this.palette;
    }

    public BitArray getBitArray() {
        return this.bitArray;
    }
}

