/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.debug;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.debug.DebugInfo;
import org.geysermc.mcprotocollib.protocol.data.game.debug.DebugSubscriptions;
import org.jetbrains.annotations.Nullable;

public class ClientboundDebugEntityValuePacket
implements MinecraftPacket {
    private final int entityId;
    private final DebugSubscriptions subscriptionType;
    @Nullable
    private final DebugInfo subscription;

    public ClientboundDebugEntityValuePacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.subscriptionType = DebugSubscriptions.from(MinecraftTypes.readVarInt(in));
        this.subscription = MinecraftTypes.readDebugSubscriptionUpdate(in, this.subscriptionType);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        MinecraftTypes.writeVarInt(out, this.subscriptionType.ordinal());
        MinecraftTypes.writeDebugSubscriptionUpdate(out, this.subscriptionType, this.subscription);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public DebugSubscriptions getSubscriptionType() {
        return this.subscriptionType;
    }

    @Nullable
    public DebugInfo getSubscription() {
        return this.subscription;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundDebugEntityValuePacket)) {
            return false;
        }
        ClientboundDebugEntityValuePacket other = (ClientboundDebugEntityValuePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        DebugSubscriptions this$subscriptionType = this.getSubscriptionType();
        DebugSubscriptions other$subscriptionType = other.getSubscriptionType();
        if (this$subscriptionType == null ? other$subscriptionType != null : !((Object)((Object)this$subscriptionType)).equals((Object)other$subscriptionType)) {
            return false;
        }
        DebugInfo this$subscription = this.getSubscription();
        DebugInfo other$subscription = other.getSubscription();
        return !(this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof ClientboundDebugEntityValuePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        DebugSubscriptions $subscriptionType = this.getSubscriptionType();
        result = result * 59 + ($subscriptionType == null ? 43 : ((Object)((Object)$subscriptionType)).hashCode());
        DebugInfo $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundDebugEntityValuePacket(entityId=" + this.getEntityId() + ", subscriptionType=" + String.valueOf((Object)this.getSubscriptionType()) + ", subscription=" + String.valueOf(this.getSubscription()) + ")";
    }

    public @NonNull ClientboundDebugEntityValuePacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundDebugEntityValuePacket(entityId, this.subscriptionType, this.subscription);
    }

    public @NonNull ClientboundDebugEntityValuePacket withSubscriptionType(DebugSubscriptions subscriptionType) {
        return this.subscriptionType == subscriptionType ? this : new ClientboundDebugEntityValuePacket(this.entityId, subscriptionType, this.subscription);
    }

    public @NonNull ClientboundDebugEntityValuePacket withSubscription(@Nullable DebugInfo subscription) {
        return this.subscription == subscription ? this : new ClientboundDebugEntityValuePacket(this.entityId, this.subscriptionType, subscription);
    }

    public ClientboundDebugEntityValuePacket(int entityId, DebugSubscriptions subscriptionType, @Nullable DebugInfo subscription) {
        this.entityId = entityId;
        this.subscriptionType = subscriptionType;
        this.subscription = subscription;
    }
}

