/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class ClientboundRemoveMobEffectPacket
implements MinecraftPacket {
    private final int entityId;
    @lombok.NonNull
    private final Effect effect;

    public ClientboundRemoveMobEffectPacket(ByteBuf in) {
        this.entityId = MinecraftTypes.readVarInt(in);
        this.effect = MinecraftTypes.readEffect(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.entityId);
        MinecraftTypes.writeEffect(out, this.effect);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @lombok.NonNull
    public Effect getEffect() {
        return this.effect;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRemoveMobEffectPacket)) {
            return false;
        }
        ClientboundRemoveMobEffectPacket other = (ClientboundRemoveMobEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        Effect this$effect = this.getEffect();
        Effect other$effect = other.getEffect();
        return !(this$effect == null ? other$effect != null : !((Object)((Object)this$effect)).equals((Object)other$effect));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundRemoveMobEffectPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        Effect $effect = this.getEffect();
        result = result * 59 + ($effect == null ? 43 : ((Object)((Object)$effect)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundRemoveMobEffectPacket(entityId=" + this.getEntityId() + ", effect=" + String.valueOf((Object)this.getEffect()) + ")";
    }

    public @NonNull ClientboundRemoveMobEffectPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundRemoveMobEffectPacket(entityId, this.effect);
    }

    public @NonNull ClientboundRemoveMobEffectPacket withEffect(@lombok.NonNull Effect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        return this.effect == effect ? this : new ClientboundRemoveMobEffectPacket(this.entityId, effect);
    }

    public ClientboundRemoveMobEffectPacket(int entityId, @lombok.NonNull Effect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        this.entityId = entityId;
        this.effect = effect;
    }
}

