/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundSetExperiencePacket
implements MinecraftPacket {
    private final float experience;
    private final int level;
    private final int totalExperience;

    public ClientboundSetExperiencePacket(ByteBuf in) {
        this.experience = in.readFloat();
        this.level = MinecraftTypes.readVarInt(in);
        this.totalExperience = MinecraftTypes.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeFloat(this.experience);
        MinecraftTypes.writeVarInt(out, this.level);
        MinecraftTypes.writeVarInt(out, this.totalExperience);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getLevel() {
        return this.level;
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetExperiencePacket)) {
            return false;
        }
        ClientboundSetExperiencePacket other = (ClientboundSetExperiencePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getExperience(), other.getExperience()) != 0) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        return this.getTotalExperience() == other.getTotalExperience();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetExperiencePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getExperience());
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getTotalExperience();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetExperiencePacket(experience=" + this.getExperience() + ", level=" + this.getLevel() + ", totalExperience=" + this.getTotalExperience() + ")";
    }

    public @NonNull ClientboundSetExperiencePacket withExperience(float experience) {
        return this.experience == experience ? this : new ClientboundSetExperiencePacket(experience, this.level, this.totalExperience);
    }

    public @NonNull ClientboundSetExperiencePacket withLevel(int level) {
        return this.level == level ? this : new ClientboundSetExperiencePacket(this.experience, level, this.totalExperience);
    }

    public @NonNull ClientboundSetExperiencePacket withTotalExperience(int totalExperience) {
        return this.totalExperience == totalExperience ? this : new ClientboundSetExperiencePacket(this.experience, this.level, totalExperience);
    }

    public ClientboundSetExperiencePacket(float experience, int level, int totalExperience) {
        this.experience = experience;
        this.level = level;
        this.totalExperience = totalExperience;
    }
}

