/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.neoforge;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.lifecycle.GeyserRegisterPermissionsEvent;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.platform.neoforge.PermissionUtils;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.neoforge.PermissionNotRegisteredException;

public class GeyserNeoForgeCommandRegistry
extends CommandRegistry {
    private final Set<String> undefinedPermissions = new HashSet<String>();

    public GeyserNeoForgeCommandRegistry(GeyserImpl geyser, CommandManager<GeyserCommandSource> cloud) {
        super(geyser, cloud);
    }

    @Override
    protected void register(GeyserCommand command, Map<String, GeyserCommand> commands) {
        super.register(command, commands);
        if (!command.permission().isBlank() && command.permissionDefault() == null) {
            this.undefinedPermissions.add(command.permission());
        }
    }

    @Override
    protected void onRegisterPermissions(GeyserRegisterPermissionsEvent event) {
        super.onRegisterPermissions(event);
        this.undefinedPermissions.removeAll(this.permissionDefaults.keySet());
    }

    void onPermissionGatherForUndefined(PermissionGatherEvent.Nodes event) {
        for (String permission : this.undefinedPermissions) {
            if (!PermissionUtils.register(permission, TriState.NOT_SET, event)) continue;
            this.geyser.getLogger().debug("Registered permission " + permission + " with fallback default value of NOT_SET");
        }
    }

    @Override
    public boolean hasPermission(GeyserCommandSource source, String permission) {
        try {
            return super.hasPermission(source, permission);
        }
        catch (PermissionNotRegisteredException e) {
            return false;
        }
    }
}

