/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.jetbrains.annotations.Range;

public class CrafterContainer
extends Container {
    private GeyserItemStack resultItem = GeyserItemStack.EMPTY;
    private boolean triggered = false;
    private short disabledSlotsMask = 0;

    public CrafterContainer(GeyserSession session, String title, int id, int size, ContainerType containerType, PlayerInventory playerInventory, InventoryTranslator translator) {
        super(session, title, id, size, containerType, playerInventory, translator);
    }

    @Override
    public GeyserItemStack getItem(int slot) {
        if (slot == 45) {
            return this.resultItem;
        }
        if (CrafterContainer.isCraftingGrid(slot)) {
            return super.getItem(slot);
        }
        return this.playerInventory.getItem(slot - 9 + 9);
    }

    @Override
    public int getOffsetForHotbar(@Range(from=0L, to=8L) int slot) {
        return this.playerInventory.getOffsetForHotbar(slot) - 9 + 9;
    }

    @Override
    public void setItem(int slot, @NonNull GeyserItemStack newItem, GeyserSession session) {
        if (slot == 45) {
            this.resultItem = newItem;
        } else if (CrafterContainer.isCraftingGrid(slot)) {
            super.setItem(slot, newItem, session);
        } else {
            this.playerInventory.setItem(slot - 9 + 9, newItem, session);
        }
    }

    public void setSlot(int slot, boolean enabled) {
        if (!CrafterContainer.isCraftingGrid(slot)) {
            GeyserImpl.getInstance().getLogger().warning("Crafter slot out of bounds: " + slot);
            return;
        }
        this.disabledSlotsMask = enabled ? (short)(this.disabledSlotsMask & ~(1 << slot)) : (short)(this.disabledSlotsMask | 1 << slot);
    }

    private static boolean isCraftingGrid(int slot) {
        return slot >= 0 && slot <= 8;
    }

    public GeyserItemStack getResultItem() {
        return this.resultItem;
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public short getDisabledSlotsMask() {
        return this.disabledSlotsMask;
    }

    public void setTriggered(boolean triggered) {
        this.triggered = triggered;
    }
}

