/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.impl.security.AbstractPrivateJwk;
import io.jsonwebtoken.impl.security.DefaultEcPublicJwk;
import io.jsonwebtoken.impl.security.FieldElementConverter;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.security.EcPrivateJwk;
import io.jsonwebtoken.security.EcPublicJwk;
import io.jsonwebtoken.security.PrivateJwk;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Set;

class DefaultEcPrivateJwk
extends AbstractPrivateJwk<ECPrivateKey, ECPublicKey, EcPublicJwk>
implements EcPrivateJwk {
    static final Parameter<BigInteger> D = (Parameter)Parameters.bigInt("d", "ECC Private Key").setConverter(FieldElementConverter.B64URL_CONVERTER).setSecret(true).build();
    static final Set<Parameter<?>> PARAMS = Collections.concat(DefaultEcPublicJwk.PARAMS, D);

    DefaultEcPrivateJwk(JwkContext<ECPrivateKey> ctx, EcPublicJwk pubJwk) {
        super(ctx, DefaultEcPublicJwk.THUMBPRINT_PARAMS, pubJwk);
    }

    @Override
    protected boolean equals(PrivateJwk<?, ?, ?> jwk) {
        return jwk instanceof EcPrivateJwk && DefaultEcPublicJwk.equalsPublic(this, jwk) && Parameters.equals(this, jwk, D);
    }
}

