/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.requests.impl.GetRequest;
import net.raphimc.minecraftauth.responsehandler.MinecraftResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.java.StepMCToken;
import net.raphimc.minecraftauth.util.UuidUtil;
import net.raphimc.minecraftauth.util.logging.ILogger;

public class StepMCProfile
extends AbstractStep<StepMCToken.MCToken, MCProfile> {
    public static final String MINECRAFT_PROFILE_URL = "https://api.minecraftservices.com/minecraft/profile";

    public StepMCProfile(AbstractStep<?, StepMCToken.MCToken> prevStep) {
        super("mcProfile", prevStep);
    }

    @Override
    protected MCProfile execute(ILogger logger, HttpClient httpClient, StepMCToken.MCToken mcToken) throws Exception {
        logger.info(this, "Getting profile...");
        GetRequest getRequest = new GetRequest(MINECRAFT_PROFILE_URL);
        getRequest.setHeader("Authorization", mcToken.getTokenType() + " " + mcToken.getAccessToken());
        JsonObject obj = httpClient.execute(getRequest, new MinecraftResponseHandler());
        MCProfile mcProfile = new MCProfile(UuidUtil.fromLenientString(obj.get("id").getAsString()), obj.get("name").getAsString(), obj.get("skins").getAsJsonArray().get(0).getAsJsonObject().get("url").getAsString(), mcToken);
        logger.info(this, "Got MC Profile, name: " + mcProfile.name + ", uuid: " + mcProfile.id);
        return mcProfile;
    }

    @Override
    public MCProfile fromJson(JsonObject json) {
        StepMCToken.MCToken mcToken = this.prevStep != null ? (StepMCToken.MCToken)this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        return new MCProfile(UUID.fromString(json.get("id").getAsString()), json.get("name").getAsString(), json.get("skinUrl").getAsString(), mcToken);
    }

    @Override
    public JsonObject toJson(MCProfile mcProfile) {
        JsonObject json = new JsonObject();
        json.addProperty("id", mcProfile.id.toString());
        json.addProperty("name", mcProfile.name);
        json.addProperty("skinUrl", mcProfile.skinUrl);
        if (this.prevStep != null) {
            json.add(this.prevStep.name, (JsonElement)this.prevStep.toJson(mcProfile.mcToken));
        }
        return json;
    }

    public static final class MCProfile
    extends AbstractStep.StepResult<StepMCToken.MCToken> {
        private final UUID id;
        private final String name;
        private final String skinUrl;
        private final StepMCToken.MCToken mcToken;

        @Override
        protected StepMCToken.MCToken prevResult() {
            return this.mcToken;
        }

        @Override
        public boolean isExpired() {
            return this.prevResult().isExpired();
        }

        @Override
        public boolean isExpiredOrOutdated() {
            return true;
        }

        @Generated
        public MCProfile(UUID id, String name, String skinUrl, StepMCToken.MCToken mcToken) {
            this.id = id;
            this.name = name;
            this.skinUrl = skinUrl;
            this.mcToken = mcToken;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getSkinUrl() {
            return this.skinUrl;
        }

        @Generated
        public StepMCToken.MCToken getMcToken() {
            return this.mcToken;
        }

        @Generated
        public String toString() {
            return "StepMCProfile.MCProfile(id=" + this.getId() + ", name=" + this.getName() + ", skinUrl=" + this.getSkinUrl() + ", mcToken=" + this.getMcToken() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MCProfile)) {
                return false;
            }
            MCProfile other = (MCProfile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$skinUrl = this.getSkinUrl();
            String other$skinUrl = other.getSkinUrl();
            if (this$skinUrl == null ? other$skinUrl != null : !this$skinUrl.equals(other$skinUrl)) {
                return false;
            }
            StepMCToken.MCToken this$mcToken = this.getMcToken();
            StepMCToken.MCToken other$mcToken = other.getMcToken();
            return !(this$mcToken == null ? other$mcToken != null : !((Object)this$mcToken).equals(other$mcToken));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MCProfile;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $skinUrl = this.getSkinUrl();
            result = result * 59 + ($skinUrl == null ? 43 : $skinUrl.hashCode());
            StepMCToken.MCToken $mcToken = this.getMcToken();
            result = result * 59 + ($mcToken == null ? 43 : ((Object)$mcToken).hashCode());
            return result;
        }
    }
}

