/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.common.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.cloudburstmc.protocol.common.util.Preconditions;

public final class TypeMap<T> {
    private final String type;
    private final Object2IntMap<T> toId;
    private final Int2ObjectMap<T> toObject;

    private TypeMap(String type, Object2IntMap<T> toId, Int2ObjectMap<T> toObject) {
        this.type = type;
        this.toId = toId;
        this.toObject = toObject;
    }

    public int getId(T value) {
        Preconditions.checkNotNull(value, "value");
        int index = this.toId.getInt(value);
        Preconditions.checkArgument(index != -1, "No id found for %s", value);
        return index;
    }

    public int getIdUnsafe(T value) {
        Preconditions.checkNotNull(value, "value");
        return this.toId.getInt(value);
    }

    public T getType(int id) {
        Object value = this.toObject.get(id);
        Preconditions.checkNotNull(value, "type null for id %s", id);
        return (T)value;
    }

    public T getTypeUnsafe(int id) {
        return (T)this.toObject.get(id);
    }

    public Builder<T> toBuilder() {
        Builder builder = new Builder(this.type);
        this.toObject.forEach((BiConsumer<Integer, T>)((BiConsumer<Integer, Object>)builder::insert));
        return builder;
    }

    public void forEach(BiConsumer<Integer, T> consumer) {
        this.toObject.forEach(consumer);
    }

    public static <T> Builder<T> builder(Class<T> typeClass) {
        return new Builder(typeClass.getSimpleName());
    }

    public static <T> Builder<T> builder(String type) {
        return new Builder(type);
    }

    public static <T> TypeMap<T> empty(Class<T> typeClass) {
        return TypeMap.empty(typeClass.getSimpleName());
    }

    public static <T> TypeMap<T> empty(String type) {
        return new TypeMap(type, Object2IntMaps.emptyMap(), Int2ObjectMaps.emptyMap());
    }

    private static int powerOfTwoCeiling(int value) {
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return ++value;
    }

    public String prettyPrint() {
        TreeMap map = new TreeMap(this.toObject);
        StringJoiner joiner = new StringJoiner("\n");
        for (Map.Entry entry : map.entrySet()) {
            joiner.add(entry.getKey() + " => " + entry.getValue());
        }
        return joiner.toString();
    }

    public static <T extends Enum<T>> TypeMap<T> fromEnum(Class<T> clazz) {
        return TypeMap.fromEnum(clazz, -1);
    }

    public static <T extends Enum<T>> TypeMap<T> fromEnum(Class<T> clazz, int maxIndex) {
        EnumSet<Enum> values = EnumSet.allOf(clazz);
        Builder<Enum> builder = TypeMap.builder(clazz);
        for (Enum value : values) {
            if (maxIndex != -1 && value.ordinal() > maxIndex) break;
            builder.insert(value.ordinal(), value);
        }
        return builder.build();
    }

    public static class Builder<T> {
        private final String type;
        private final Int2ObjectAVLTreeMap<Object> types = new Int2ObjectAVLTreeMap();

        public Builder<T> insert(int index, T value) {
            Preconditions.checkNotNull(value, "value");
            Preconditions.checkArgument(this.types.get(index) == null, "Cannot insert into non-null value at index " + index);
            this.types.put(index, (Object)value);
            return this;
        }

        public Builder<T> shift(int startIndex, int amount) {
            Int2ObjectSortedMap<Object> shiftMap = this.types.tailMap(startIndex);
            Int2ObjectArrayMap tmp = new Int2ObjectArrayMap(shiftMap.size());
            for (Int2ObjectMap.Entry entry : shiftMap.int2ObjectEntrySet()) {
                tmp.put(entry.getIntKey() + amount, entry.getValue());
                this.types.put(entry.getIntKey(), (Object)null);
            }
            this.types.putAll(tmp);
            return this;
        }

        public Builder<T> replace(int index, T value) {
            Preconditions.checkNotNull(value, "value");
            Preconditions.checkArgument(this.types.get(index) != null, "Cannot update null value");
            this.types.put(index, (Object)value);
            return this;
        }

        public Builder<T> update(int oldIndex, int newIndex, T value) {
            Preconditions.checkNotNull(value, "value");
            Preconditions.checkArgument(this.types.get(oldIndex) == value, "oldIndex value does not equal expected");
            this.types.remove(oldIndex);
            this.types.put(newIndex, (Object)value);
            return this;
        }

        public Builder<T> insert(int offset, TypeMap<? extends T> map) {
            Preconditions.checkNotNull(map, "map");
            ((TypeMap)map).toObject.forEach((index, value) -> {
                int newIndex = index + offset;
                Preconditions.checkNotNull(value, "value");
                this.types.put(newIndex, value);
            });
            return this;
        }

        public Builder<T> remove(int index) {
            this.types.remove(index);
            return this;
        }

        public TypeMap<T> build() {
            Object2IntOpenHashMap toId = new Object2IntOpenHashMap();
            toId.defaultReturnValue(-1);
            Int2ObjectOpenHashMap toObject = new Int2ObjectOpenHashMap();
            for (Int2ObjectMap.Entry entry : this.types.int2ObjectEntrySet()) {
                Object type = entry.getValue();
                if (type == null) continue;
                toId.put(type, entry.getIntKey());
                toObject.put(entry.getIntKey(), type);
            }
            return new TypeMap(this.type, toId, toObject);
        }

        private Builder(String type) {
            this.type = type;
        }
    }
}

