/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.EnchantOptionData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftRecipeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.cloudburstmc.protocol.bedrock.packet.PlayerEnchantOptionsPacket;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.EnchantingContainer;
import org.geysermc.geyser.inventory.GeyserEnchantOption;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntSets;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;

public class EnchantingInventoryTranslator
extends AbstractBlockInventoryTranslator {
    public EnchantingInventoryTranslator() {
        super(2, Blocks.ENCHANTING_TABLE, org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType.ENCHANTMENT, (InventoryUpdater)UIInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
        int slotToUpdate;
        EnchantingContainer enchantingInventory = (EnchantingContainer)inventory;
        boolean shouldUpdate = false;
        switch (key) {
            case 0: 
            case 1: 
            case 2: {
                slotToUpdate = key;
                enchantingInventory.getGeyserEnchantOptions()[slotToUpdate].setXpCost(value);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                slotToUpdate = key - 4;
                int bedrockIndex = value;
                if (bedrockIndex != -1) {
                    Enchantment enchantment = session.getRegistryCache().enchantments().byId(value);
                    bedrockIndex = enchantment != null && enchantment.bedrockEnchantment() != null ? enchantment.bedrockEnchantment().ordinal() : -1;
                }
                enchantingInventory.getGeyserEnchantOptions()[slotToUpdate].setEnchantIndex(bedrockIndex);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                slotToUpdate = key - 7;
                enchantingInventory.getGeyserEnchantOptions()[slotToUpdate].setEnchantLevel(value);
                shouldUpdate = true;
                break;
            }
            default: {
                return;
            }
        }
        GeyserEnchantOption enchantOption = enchantingInventory.getGeyserEnchantOptions()[slotToUpdate];
        if (shouldUpdate && enchantOption.hasChanged()) {
            enchantingInventory.getEnchantOptions()[slotToUpdate] = enchantOption.build(session);
            PlayerEnchantOptionsPacket packet = new PlayerEnchantOptionsPacket();
            packet.getOptions().addAll(Arrays.asList(enchantingInventory.getEnchantOptions()));
            session.sendUpstreamPacket(packet);
        }
    }

    @Override
    protected boolean shouldHandleRequestFirst(ItemStackRequestAction action, Inventory inventory) {
        return action.getType() == ItemStackRequestActionType.CRAFT_RECIPE;
    }

    @Override
    public ItemStackResponse translateSpecialRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        CraftRecipeAction craftRecipeData = (CraftRecipeAction)request.getActions()[0];
        EnchantingContainer enchantingInventory = (EnchantingContainer)inventory;
        int javaSlot = -1;
        for (int i = 0; i < enchantingInventory.getEnchantOptions().length; ++i) {
            EnchantOptionData enchantData = enchantingInventory.getEnchantOptions()[i];
            if (enchantData == null || craftRecipeData.getRecipeNetworkId() != enchantData.getEnchantNetId()) continue;
            javaSlot = enchantingInventory.getGeyserEnchantOptions()[i].getJavaIndex();
            break;
        }
        if (javaSlot == -1) {
            return EnchantingInventoryTranslator.rejectRequest(request);
        }
        ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(inventory.getJavaId(), javaSlot);
        session.sendDownstreamGamePacket(packet);
        return EnchantingInventoryTranslator.acceptRequest(request, this.makeContainerEntries(session, inventory, IntSets.emptySet()));
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        if (slotInfoData.getContainerName().getContainer() == ContainerSlotType.ENCHANTING_INPUT) {
            return 0;
        }
        if (slotInfoData.getContainerName().getContainer() == ContainerSlotType.ENCHANTING_MATERIAL) {
            return 1;
        }
        return super.bedrockSlotToJava(slotInfoData);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        if (slot == 0) {
            return new BedrockContainerSlot(ContainerSlotType.ENCHANTING_INPUT, 14);
        }
        if (slot == 1) {
            return new BedrockContainerSlot(ContainerSlotType.ENCHANTING_MATERIAL, 15);
        }
        return super.javaSlotToBedrockContainer(slot);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        if (slot == 0) {
            return 14;
        }
        if (slot == 1) {
            return 15;
        }
        return super.javaSlotToBedrock(slot);
    }

    @Override
    public Inventory createInventory(String name, int windowId, ContainerType containerType, PlayerInventory playerInventory) {
        return new EnchantingContainer(name, windowId, this.size, containerType, playerInventory);
    }

    @Override
    public @Nullable org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType closeContainerType(Inventory inventory) {
        return null;
    }
}

