/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock;

import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.BedrockPeer;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.PacketSignal;

public abstract class BedrockSession {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockSession.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    protected final BedrockPeer peer;
    protected final int subClientId;
    protected BedrockPacketHandler packetHandler;
    protected boolean logging;
    protected String disconnectReason = "disconnect.lost";

    public BedrockSession(BedrockPeer peer, int subClientId) {
        this.peer = peer;
        this.subClientId = subClientId;
    }

    public BedrockPacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public void setPacketHandler(@NonNull BedrockPacketHandler packetHandler) {
        this.packetHandler = packetHandler;
    }

    protected void checkForClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    public void sendPacket(@NonNull BedrockPacket packet) {
        this.peer.sendPacket(this.subClientId, 0, packet);
        this.logOutbound(packet);
    }

    public void sendPacketImmediately(@NonNull BedrockPacket packet) {
        this.peer.sendPacketImmediately(this.subClientId, 0, packet);
        this.logOutbound(packet);
    }

    public BedrockPeer getPeer() {
        return this.peer;
    }

    public BedrockCodec getCodec() {
        return this.peer.getCodec();
    }

    public void setCodec(BedrockCodec codec) {
        ObjectUtil.checkNotNull((Object)codec, (String)"codec");
        if (this.subClientId != 0) {
            throw new IllegalStateException("The packet codec can only be set by the primary session");
        }
        this.peer.setCodec(codec);
    }

    public void setCompression(PacketCompressionAlgorithm algorithm) {
        if (this.isSubClient()) {
            throw new IllegalStateException("The compression algorithm can only be set by the primary session");
        }
        this.peer.setCompression(algorithm);
    }

    public void enableEncryption(SecretKey key) {
        if (this.isSubClient()) {
            throw new IllegalStateException("Encryption can only be enabled by the primary session");
        }
        this.peer.enableEncryption(key);
    }

    public void close(String reason) {
        this.checkForClosed();
        if (!this.isSubClient()) {
            this.peer.close(reason);
        }
    }

    protected void onClose() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.packetHandler != null) {
            try {
                this.packetHandler.onDisconnect(this.disconnectReason);
            }
            catch (Exception e) {
                log.error("Exception thrown while handling disconnect", (Throwable)e);
            }
        }
        this.peer.removeSession(this);
    }

    protected void onPacket(BedrockPacketWrapper wrapper) {
        BedrockPacket packet = wrapper.getPacket();
        this.logInbound(packet);
        if (this.packetHandler == null) {
            if (log.isDebugEnabled()) {
                log.debug("Received packet without a packet handler for {}:{}: {}", new Object[]{this.getSocketAddress(), this.subClientId, packet});
            }
        } else if (this.packetHandler.handlePacket(packet) == PacketSignal.UNHANDLED && log.isDebugEnabled()) {
            log.debug("Unhandled packet for {}:{}: {}", new Object[]{this.getSocketAddress(), this.subClientId, packet});
        }
    }

    protected void logOutbound(BedrockPacket packet) {
        if (log.isTraceEnabled() && this.logging) {
            log.trace("Outbound {}{}: {}", new Object[]{this.getSocketAddress(), this.subClientId, packet});
        }
    }

    protected void logInbound(BedrockPacket packet) {
        if (log.isTraceEnabled() && this.logging) {
            log.trace("Inbound {}{}: {}", new Object[]{this.getSocketAddress(), this.subClientId, packet});
        }
    }

    public SocketAddress getSocketAddress() {
        return this.peer.getSocketAddress();
    }

    public boolean isSubClient() {
        return this.subClientId != 0;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public String getDisconnectReason() {
        return this.disconnectReason;
    }

    public void setDisconnectReason(String disconnectReason) {
        this.disconnectReason = disconnectReason;
    }

    public final void disconnect() {
        this.disconnect("disconnect.disconnected");
    }

    public final void disconnect(String reason) {
        this.disconnect(reason, false);
    }

    public abstract void disconnect(String var1, boolean var2);

    public boolean isConnected() {
        return !this.closed.get();
    }
}

