/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;

public class CraftingInventoryTranslator
extends AbstractBlockInventoryTranslator {
    public CraftingInventoryTranslator() {
        super(10, Blocks.CRAFTING_TABLE, ContainerType.WORKBENCH, (InventoryUpdater)UIInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    public int getGridSize() {
        return 9;
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 0) {
            return SlotType.OUTPUT;
        }
        return SlotType.NORMAL;
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        if (CraftingInventoryTranslator.isCraftingGrid(slot)) {
            return new BedrockContainerSlot(ContainerSlotType.CRAFTING_INPUT, slot + 31);
        }
        if (slot == 0) {
            return new BedrockContainerSlot(ContainerSlotType.CRAFTING_OUTPUT, 0);
        }
        return super.javaSlotToBedrockContainer(slot);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        if (slotInfoData.getContainerName().getContainer() == ContainerSlotType.CRAFTING_INPUT) {
            return slotInfoData.getSlot() - 31;
        }
        if (slotInfoData.getContainerName().getContainer() == ContainerSlotType.CRAFTING_OUTPUT || slotInfoData.getContainerName().getContainer() == ContainerSlotType.CREATED_OUTPUT) {
            return 0;
        }
        return super.bedrockSlotToJava(slotInfoData);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        if (slot < this.size) {
            return slot == 0 ? 50 : slot + 31;
        }
        return super.javaSlotToBedrock(slot);
    }

    public static boolean isCraftingGrid(int slot) {
        return slot >= 1 && slot <= 9;
    }

    @Override
    public ContainerType closeContainerType(Inventory inventory) {
        return null;
    }
}

