/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import java.util.List;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.event.type.SessionDisconnectEventImpl;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TextComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.TranslatableComponent;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;

public final class SessionDisconnectListener {
    private SessionDisconnectListener() {
    }

    public static void onSessionDisconnect(SessionDisconnectEventImpl event) {
        Component disconnectReason = event.getReasonComponent();
        GeyserSession session = (GeyserSession)event.connection();
        String serverDisconnectMessage = MessageTranslator.convertMessage(disconnectReason, session.locale());
        if (SessionDisconnectListener.testForOutdatedServer(disconnectReason)) {
            String locale = session.locale();
            PlatformType platform = session.getGeyser().platformType();
            String outdatedType = platform == PlatformType.BUNGEECORD || platform == PlatformType.VELOCITY || platform == PlatformType.VIAPROXY ? "geyser.network.remote.outdated.proxy" : "geyser.network.remote.outdated.server";
            event.disconnectReason(GeyserLocale.getPlayerLocaleString(outdatedType, locale, GameProtocol.getJavaVersions().get(0)) + "\n" + GeyserLocale.getPlayerLocaleString("geyser.network.remote.original_disconnect_message", locale, serverDisconnectMessage));
        } else if (SessionDisconnectListener.testForMissingProfilePublicKey(disconnectReason)) {
            event.disconnectReason("Please set `enforce-secure-profile` to `false` in server.properties for Bedrock players to be able to connect.\n" + GeyserLocale.getPlayerLocaleString("geyser.network.remote.original_disconnect_message", session.locale(), serverDisconnectMessage));
        }
    }

    private static boolean testForOutdatedServer(Component disconnectReason) {
        if (disconnectReason instanceof TranslatableComponent) {
            TranslatableComponent component = (TranslatableComponent)disconnectReason;
            String key = component.key();
            return "multiplayer.disconnect.incompatible".equals(key) || "multiplayer.disconnect.outdated_client".equals(key) || "multiplayer.disconnect.outdated_server".equals(key) || key.startsWith("Outdated server!");
        }
        if (disconnectReason instanceof TextComponent) {
            TextComponent component = (TextComponent)disconnectReason;
            if (component.content().startsWith("Outdated server!")) {
                return true;
            }
            List<Component> children = component.children();
            for (Component value : children) {
                TextComponent child;
                if (!(value instanceof TextComponent) || !(child = (TextComponent)value).content().startsWith("Outdated server!")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean testForMissingProfilePublicKey(Component disconnectReason) {
        TranslatableComponent component;
        return disconnectReason instanceof TranslatableComponent && "multiplayer.disconnect.missing_public_key".equals((component = (TranslatableComponent)disconnectReason).key());
    }
}

