/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock.entity.player;

import org.cloudburstmc.protocol.bedrock.packet.EmotePacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.bedrock.ClientEmoteEvent;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=EmotePacket.class)
public class BedrockEmoteTranslator
extends PacketTranslator<EmotePacket> {
    @Override
    public void translate(GeyserSession session, EmotePacket packet) {
        ClientEmoteEvent event = new ClientEmoteEvent(session, packet.getEmoteId());
        if (!GeyserImpl.getInstance().config().gameplay().emotesEnabled()) {
            event.setCancelled(true);
        }
        session.getGeyser().eventBus().fire(event);
        if (event.isCancelled()) {
            return;
        }
        int javaId = session.getPlayerEntity().getEntityId();
        String xuid = session.getAuthData().xuid();
        String emote = packet.getEmoteId();
        for (GeyserSession otherSession : session.getGeyser().getSessionManager().getSessions().values()) {
            if (otherSession == session || otherSession.isClosed()) continue;
            otherSession.ensureInEventLoop(() -> BedrockEmoteTranslator.playEmote(otherSession, javaId, xuid, emote));
        }
    }

    private static void playEmote(GeyserSession session, int emoterJavaId, String emoterXuid, String emoteId) {
        Entity emoter = session.getEntityCache().getEntityByJavaId(emoterJavaId);
        if (emoter instanceof PlayerEntity) {
            EmotePacket packet = new EmotePacket();
            packet.setRuntimeEntityId(emoter.getGeyserId());
            packet.setXuid(emoterXuid);
            packet.setPlatformId("");
            packet.setEmoteId(emoteId);
            session.sendUpstreamPacket(packet);
        }
    }
}

