/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.registry.type.SoundMapping;

public class SoundRegistryLoader
implements RegistryLoader<String, Map<String, SoundMapping>> {
    @Override
    public Map<String, SoundMapping> load(String input) {
        JsonObject soundsJson;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(input);
             InputStreamReader isr = new InputStreamReader(stream);){
            soundsJson = new JsonParser().parse((Reader)isr).getAsJsonObject();
        }
        catch (IOException e) {
            throw new AssertionError("Unable to load sound mappings", e);
        }
        HashMap<String, SoundMapping> soundMappings = new HashMap<String, SoundMapping>();
        for (Map.Entry entry : soundsJson.entrySet()) {
            JsonObject brMap = ((JsonElement)entry.getValue()).getAsJsonObject();
            String javaSound = (String)entry.getKey();
            soundMappings.put(javaSound, new SoundMapping(javaSound, brMap.has("bedrock_mapping") ? brMap.get("bedrock_mapping").getAsString() : null, brMap.has("playsound_mapping") ? brMap.get("playsound_mapping").getAsString() : null, brMap.has("extra_data") ? brMap.get("extra_data").getAsInt() : -1, brMap.has("identifier") ? brMap.get("identifier").getAsString() : null, brMap.has("level_event") && brMap.get("level_event").getAsBoolean(), brMap.has("pitch_adjust") ? brMap.get("pitch_adjust").getAsFloat() : 1.0f));
        }
        return soundMappings;
    }
}

