/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord.command;

import java.util.Locale;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import org.geysermc.geyser.text.GeyserLocale;

public class BungeeCommandSource
implements GeyserCommandSource {
    private final CommandSender handle;
    private static final int PROTOCOL_HEX_COLOR = 713;

    public BungeeCommandSource(CommandSender handle) {
        this.handle = handle;
        GeyserLocale.loadGeyserLocale(this.locale());
    }

    @Override
    public String name() {
        return this.handle.getName();
    }

    @Override
    public void sendMessage(@NonNull String message) {
        this.handle.sendMessage(TextComponent.fromLegacyText((String)message));
    }

    @Override
    public void sendMessage(Component message) {
        ProxiedPlayer player;
        CommandSender commandSender = this.handle;
        if (commandSender instanceof ProxiedPlayer && (player = (ProxiedPlayer)commandSender).getPendingConnection().getVersion() >= 713) {
            this.handle.sendMessage(BungeeComponentSerializer.get().serialize(message));
            return;
        }
        this.handle.sendMessage(BungeeComponentSerializer.legacy().serialize(message));
    }

    @Override
    public boolean isConsole() {
        return !(this.handle instanceof ProxiedPlayer);
    }

    @Override
    public @Nullable UUID playerUuid() {
        CommandSender commandSender = this.handle;
        if (commandSender instanceof ProxiedPlayer) {
            ProxiedPlayer player = (ProxiedPlayer)commandSender;
            return player.getUniqueId();
        }
        return null;
    }

    @Override
    public String locale() {
        ProxiedPlayer player;
        Locale locale;
        CommandSender commandSender = this.handle;
        if (commandSender instanceof ProxiedPlayer && (locale = (player = (ProxiedPlayer)commandSender).getLocale()) != null) {
            return GeyserLocale.formatLocale(locale.getLanguage() + "_" + locale.getCountry());
        }
        return GeyserLocale.getDefaultLocale();
    }

    @Override
    public boolean hasPermission(String permission) {
        return permission.isBlank() || this.handle.hasPermission(permission);
    }

    @Override
    public Object handle() {
        return this.handle;
    }
}

