/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundPickItemFromBlockPacket
implements MinecraftPacket {
    private final Vector3i pos;
    private final boolean includeData;

    public ServerboundPickItemFromBlockPacket(ByteBuf in) {
        this.pos = MinecraftTypes.readPosition(in);
        this.includeData = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.pos);
        out.writeBoolean(this.includeData);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Vector3i getPos() {
        return this.pos;
    }

    public boolean isIncludeData() {
        return this.includeData;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPickItemFromBlockPacket)) {
            return false;
        }
        ServerboundPickItemFromBlockPacket other = (ServerboundPickItemFromBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIncludeData() != other.isIncludeData()) {
            return false;
        }
        Vector3i this$pos = this.getPos();
        Vector3i other$pos = other.getPos();
        return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPickItemFromBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeData() ? 79 : 97);
        Vector3i $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPickItemFromBlockPacket(pos=" + String.valueOf(this.getPos()) + ", includeData=" + this.isIncludeData() + ")";
    }

    public @NonNull ServerboundPickItemFromBlockPacket withPos(Vector3i pos) {
        return this.pos == pos ? this : new ServerboundPickItemFromBlockPacket(pos, this.includeData);
    }

    public @NonNull ServerboundPickItemFromBlockPacket withIncludeData(boolean includeData) {
        return this.includeData == includeData ? this : new ServerboundPickItemFromBlockPacket(this.pos, includeData);
    }

    public ServerboundPickItemFromBlockPacket(Vector3i pos, boolean includeData) {
        this.pos = pos;
        this.includeData = includeData;
    }
}

