/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import java.util.Collections;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.MobEffectPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.EntityEffectCache;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundUpdateMobEffectPacket;

@Translator(packet=ClientboundUpdateMobEffectPacket.class)
public class JavaUpdateMobEffectTranslator
extends PacketTranslator<ClientboundUpdateMobEffectPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundUpdateMobEffectPacket packet) {
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        MobEffectPacket.Event event = MobEffectPacket.Event.ADD;
        if (entity == session.getPlayerEntity()) {
            EntityEffectCache cache = session.getEffectCache();
            if (cache.getEntityEffects().contains(packet.getEffect())) {
                event = MobEffectPacket.Event.MODIFY;
            }
            cache.setEffect(packet.getEffect(), packet.getAmplifier());
        } else if (entity instanceof ClientVehicle) {
            ClientVehicle clientVehicle = (ClientVehicle)((Object)entity);
            clientVehicle.getVehicleComponent().setEffect(packet.getEffect(), packet.getAmplifier());
        }
        MobEffectPacket mobEffectPacket = new MobEffectPacket();
        mobEffectPacket.setAmplifier(packet.getAmplifier());
        mobEffectPacket.setDuration(packet.getDuration());
        mobEffectPacket.setEvent(event);
        mobEffectPacket.setRuntimeEntityId(entity.getGeyserId());
        mobEffectPacket.setParticles(packet.isShowParticles());
        mobEffectPacket.setEffectId(EntityUtils.toBedrockEffectId(packet.getEffect()));
        session.sendUpstreamPacket((BedrockPacket)mobEffectPacket);
        if (entity == session.getPlayerEntity()) {
            AttributeData attribute;
            switch (packet.getEffect()) {
                case ABSORPTION: {
                    AttributeData attributeData = session.getPlayerEntity().getAttributes().get((Object)GeyserAttributeType.ABSORPTION);
                    break;
                }
                case SPEED: {
                    AttributeData attributeData = session.getPlayerEntity().getAttributes().get((Object)GeyserAttributeType.MOVEMENT_SPEED);
                    break;
                }
                default: {
                    AttributeData attributeData = attribute = null;
                }
            }
            if (attribute == null) {
                return;
            }
            UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
            attributesPacket.setRuntimeEntityId(entity.getGeyserId());
            attributesPacket.setAttributes(Collections.singletonList(attribute));
            session.sendUpstreamPacket((BedrockPacket)attributesPacket);
        }
    }
}

