/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundSetPassengersPacket;

@Translator(packet=ClientboundSetPassengersPacket.class)
public class JavaSetPassengersTranslator
extends PacketTranslator<ClientboundSetPassengersPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetPassengersPacket packet) {
        Entity passenger;
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        ArrayList<Entity> newPassengers = new ArrayList<Entity>();
        int @NonNull [] passengerIds = packet.getPassengerIds();
        for (int i = 0; i < passengerIds.length; ++i) {
            int passengerId = passengerIds[i];
            passenger = session.getEntityCache().getEntityByJavaId(passengerId);
            if (passenger == session.getPlayerEntity()) {
                session.getPlayerEntity().setVehicle(entity);
                session.confirmTeleport(passenger.getPosition().down(EntityDefinitions.PLAYER.offset()).toDouble());
                if (entity instanceof ClientVehicle) {
                    ClientVehicle clientVehicle = (ClientVehicle)((Object)entity);
                    clientVehicle.getVehicleComponent().onMount();
                }
            }
            if (passenger == null) continue;
            boolean rider = packet.getPassengerIds()[0] == passengerId;
            EntityLinkData.Type type = rider ? EntityLinkData.Type.RIDER : EntityLinkData.Type.PASSENGER;
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            linkPacket.setEntityLink(new EntityLinkData(entity.getGeyserId(), passenger.getGeyserId(), type, false, false, 0.0f));
            session.sendUpstreamPacket((BedrockPacket)linkPacket);
            newPassengers.add(passenger);
            passenger.setVehicle(entity);
            EntityUtils.updateRiderRotationLock(passenger, entity, true);
            EntityUtils.updateMountOffset(passenger, entity, rider, true, i, packet.getPassengerIds().length);
            passenger.updateBedrockMetadata();
        }
        List<Entity> passengers = entity.getPassengers();
        for (int i = 0; i < passengers.size(); ++i) {
            passenger = passengers.get(i);
            if (passenger == null || newPassengers.contains(passenger)) continue;
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            linkPacket.setEntityLink(new EntityLinkData(entity.getGeyserId(), passenger.getGeyserId(), EntityLinkData.Type.REMOVE, false, false, 0.0f));
            session.sendUpstreamPacket((BedrockPacket)linkPacket);
            passenger.setVehicle(null);
            EntityUtils.updateRiderRotationLock(passenger, entity, false);
            EntityUtils.updateMountOffset(passenger, entity, false, false, i, packet.getPassengerIds().length);
            passenger.updateBedrockMetadata();
            if (passenger != session.getPlayerEntity()) continue;
            if (session.getMountVehicleScheduledFuture() != null) {
                session.getMountVehicleScheduledFuture().cancel(false);
            }
            session.setSteeringLeft(false);
            session.setSteeringRight(false);
            if (!(entity instanceof ClientVehicle)) continue;
            ClientVehicle clientVehicle = (ClientVehicle)((Object)entity);
            clientVehicle.getVehicleComponent().onDismount();
        }
        entity.setPassengers(newPassengers);
        switch (entity.getDefinition().entityType()) {
            case HORSE: 
            case SKELETON_HORSE: 
            case DONKEY: 
            case MULE: 
            case RAVAGER: {
                entity.getDirtyMetadata().put(EntityDataTypes.SEAT_ROTATION_OFFSET_DEGREES, Float.valueOf(181.0f));
                entity.updateBedrockMetadata();
            }
        }
    }
}

