/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.handler.codec.raknet.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import org.cloudburstmc.netty.channel.raknet.packet.EncapsulatedPacket;
import org.cloudburstmc.netty.channel.raknet.packet.RakDatagramPacket;

public class RakDatagramCodec
extends MessageToMessageCodec<ByteBuf, RakDatagramPacket> {
    public static final String NAME = "rak-datagram-codec";
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakDatagramCodec.class);

    @Override
    protected void encode(ChannelHandlerContext ctx, RakDatagramPacket packet, List<Object> out) throws Exception {
        ByteBuf header = ctx.alloc().ioBuffer(4);
        header.writeByte((int)packet.getFlags());
        header.writeMediumLE(packet.getSequenceIndex());
        CompositeByteBuf buf = ctx.alloc().compositeBuffer(packet.getPackets().size() * 2 + 1);
        buf.addComponent(true, header);
        for (EncapsulatedPacket encapsulated : packet.getPackets()) {
            encapsulated.encode(buf);
        }
        out.add(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> list) throws Exception {
        byte potentialFlags = buffer.getByte(buffer.readerIndex());
        if ((potentialFlags & 0xFFFFFF80) == 0) {
            list.add(buffer.retain());
            return;
        }
        if ((potentialFlags & 0x40) != 0 || (potentialFlags & 0x20) != 0) {
            list.add(buffer.retain());
            return;
        }
        RakDatagramPacket packet = RakDatagramPacket.newInstance();
        try {
            packet.setFlags(buffer.readByte());
            packet.setSequenceIndex(buffer.readUnsignedMediumLE());
            while (buffer.isReadable()) {
                EncapsulatedPacket encapsulated = EncapsulatedPacket.newInstance();
                try {
                    encapsulated.decode(buffer);
                    packet.getPackets().add(encapsulated.retain());
                }
                catch (Throwable t) {
                    log.error("Error decoding encapsulated packet", t);
                    throw t;
                }
                finally {
                    encapsulated.release();
                }
            }
            list.add((Object)packet.retain());
        }
        finally {
            packet.release();
        }
    }
}

